# Configuration file for the Sphinx documentation builder.
#
# This file only contains a selection of the most common options. For a full
# list see the documentation:
# https://www.sphinx-doc.org/en/master/usage/configuration.html

import errno
import sphinx.util.osutil
import sys
sphinx.util.osutil.ENOENT = errno.ENOENT
sphinx.util.osutil.EPIPE = errno.EPIPE
sphinx.util.osutil.EINVAL = errno.EINVAL


# -- Project information -----------------------------------------------------

project = '''${project}'''
copyright = '${copyright}'
author = '${author}'

# The full version, including alpha/beta/rc tags
release = '${version}'


# -- General configuration ---------------------------------------------------

# Add any Sphinx extension module names here, as strings. They can be
# extensions coming with Sphinx (named 'sphinx.ext.*') or your custom
# ones.

extensions = [
    'myst_parser',
    'sphinxcontrib.cairosvgconverter',
]

smartquotes = False

# 'sphinx.ext.linkcode'
# Add any paths that contain templates here, relative to this directory.
templates_path = ['_templates']

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
# This pattern also affects html_static_path and html_extra_path.
exclude_patterns = []

# -- Options for LaTeX output -------------------------------------------------

latex_engine = 'lualatex'

latex_docclass = {
    'howto':'article',
    'manual':'report'
}

latex_theme = 'manual'

latex_maketitle = r'''
\makeatletter
    \begin{titlepage}
    \thispagestyle{titlepagestyle} 
    \noindent
        \begingroup % for PDF information dictionary
            \def\endgraf{ }\def\and{\& }%
            \pdfstringdefDisableCommands{\def\\{, }}% overwrite hyperref setup
            \hypersetup{pdfauthor={\@author}, pdftitle={\@title}}%
        \endgroup

    \begin{flushright}
        \py@HeaderFamily
        \sphinxlogo
        \vspace{200pt}
        {\Huge \@title }\par
        {\itshape \py@release \releaseinfo}\par
        \vspace{50pt}
        {\large
        \begin{tabular}[t]{c}
            \@author
        \end{tabular}}\par
        \vspace{50pt}
        \@date \par
    \end{flushright}
    \@thanks
    \setcounter{footnote}{0}
    \let\thanks\relax\let\maketitle\relax
    \end{titlepage} 
\makeatother
'''

latex_setup_specador = r'''
    noteBorderColor={RGB}{204,204,204},
    noteborder=1pt,
    noteBgColor={RGB}{231, 242, 250},
    hintBorderColor={RGB}{204,204,204},
    hintborder=1pt,
    hintBgColor={RGB}{242, 250, 248},
    TableRowColorHeader={RGB}{255, 255, 255},
    TableRowColorOdd={RGB}{255, 255, 255},
    TableRowColorEven={RGB}{255, 255, 255}
 '''

latex_elements = {
    'papersize': 'a4paper',
    'maxlistdepth' : '20',
    'preamble': r'''
\usepackage{listings}
\lstset{basicstyle=\footnotesize\ttfamily,breaklines=true}
\usepackage[pipeTables=true, fencedCode]{markdown}
\markdownSetup{
  renderers = {
    interblockSeparator = {%
      \par
      \medskip
      \par
    },
    link = {{\hyperref[\detokenize{#2}]{\sphinxcrossref{\DUrole{std,std-ref}{#1}}}}},
    inputVerbatim = {
      \lstinputlisting[breaklines]{#1}
    },
    inputFencedCode = {
      \markdownRendererInputVerbatim{#1}%
    },
    image = {
      \includegraphics[max width=\textwidth, max height=0.65\textheight]{../../source/extern/#2}
    },
  },
}
\usepackage{enumitem}
\setlistdepth{20}

\setlist[itemize,1]{leftmargin=!, itemindent=0pt, labelsep=0pt, labelwidth=0pt, labelindent=5pt, label={}}
\setlist[itemize,2]{leftmargin=!, itemindent=0pt, labelsep=0pt, labelwidth=0pt, labelindent=-4pt, label=$\hookrightarrow$}
\setlist[itemize,3]{leftmargin=!, itemindent=0pt, labelsep=0pt, labelwidth=0pt, labelindent=3pt, label=$\hookrightarrow$}
\setlist[itemize]{leftmargin=!, itemindent=0pt, labelsep=0pt, labelwidth=0pt, labelindent=10pt, label=$\hookrightarrow$}

\renewlist{itemize}{itemize}{20}
\renewlist{compactitem}{itemize}{20}
\setlist[compactitem]{label=$\bullet$}

\usepackage[export]{adjustbox}
\let\ORIincludegraphics\includegraphics
\renewcommand{\includegraphics}[2][]{\ORIincludegraphics[max width=\linewidth,max height=0.65\textheight,keepaspectratio,#1]{#2}}
\usepackage{hyphenat}
\usepackage{xcolor}
\usepackage{spverbatim}
\usepackage{fancyhdr}
\usepackage{lipsum}
\usepackage{framed}
\usepackage{parskip}
\setlength{\parskip}{0pt}
\IfFileExists{luatexja.sty}{\usepackage{luatexja}}{}

\let\oldsphinxlineitem\sphinxlineitem
\renewcommand\sphinxlineitem[2][]{\oldsphinxlineitem{\normalfont#2}}

\newenvironment{blockquote}{%
  \par%
  \medskip
  \leftskip=2em\rightskip=2em%
  \noindent\ignorespaces}{%
  \par\medskip}
\makeatletter
  \fancypagestyle{normal}{
    \fancyhf{}
    \fancyfoot{}
    \fancyfoot[RO,LE]{\py@HeaderFamily \thepage}
    \fancyfoot[LO,RE]{\py@HeaderFamily ${copyright}}
    \fancyhead{}
    \fancyhead[LO,RE]{\py@HeaderFamily \@title}
    \renewcommand{\headrulewidth}{1pt}
    \renewcommand{\footrulewidth}{1pt}
  }
  \fancypagestyle{plain}{
    \fancyhf{}
    \fancyfoot{}
    \fancyfoot[RO,LE]{\py@HeaderFamily \thepage}
    \fancyhead{}
    \renewcommand{\headrulewidth}{0pt}
    \renewcommand{\footrulewidth}{1pt}
  }
    \fancypagestyle{empty}{
    \fancyfoot{}
    \fancyhead{}
    \renewcommand{\headrulewidth}{0pt}
    \renewcommand{\footrulewidth}{0pt}
  }
   \fancypagestyle{titlepagestyle}{
   \fancyhf{}
   \fancyfoot[C]{\emph{Generated by Specador™ ${specador_version}. Last updated on ${.now?date}.}}
   \renewcommand{\headrulewidth}{0 mm}
  }
<#if styleVerbatimComments>
	\renewenvironment{sphinxVerbatim}[1][]{
	    \noindent\normalfont\selectfont\ignorespaces
	}{%
	    \ignorespacesafterend
	}
</#if>
\makeatother
''',
    'figure_align': 'H',
    'extraclassoptions' : 'openany',
    'maketitle': latex_maketitle,
    'sphinxsetup' : latex_setup_specador,
}

latex_show_urls = 'inline'
latex_table_style = ['colorrows']
