<#include "utils.${format}.ftl">
<#if hasCode>
<@LinkToCode declaration declarationLine />	
</#if>

.. _${id}:
	
Entity ${name}
${""?left_pad(("Entity " + name)?length, "*")}
<#if format == "pdf">
.. raw:: latex

	\label{${id}}
</#if>

<#if hasBlockDiagram>
.. container:: diagram entity
    :name: ${id}-block
		
<@Diagram "block_of_${unformatedname}.svg" "Block Diagram of ${unformatedname}"/>

    .. raw:: html
		
		<figcaption>
			<p><span class="caption-text">Block Diagram of ${unformatedname}</span><a class="headerlink" href="#${id}-block" title="Link to this image"></a></p>
		</figcaption>
</#if>

<#if comment?? && comment?has_content>
  <@Comment comment=comment />
<#elseif isPreview>
  <@AiComment "entity" commentLine 0 true/>
</#if>

<#list configurations>
<@SectionTitle "Configurations"/> 

<#items as configuration>
* ${configuration.getFormatedName()}
</#items>
</#list>

<#list generics>
.. list-table:: Generics
    :widths: 24 24 12 40
    :header-rows: 1
    :class: longtable
    
    * - Name
      - Type
      - Default
      - Description
    <#items as generic>
    <#assign comment=generic.getComment()>
    
        .. _${generic.getID()}:
    * - <@TableCellName generic />
      - <@GenericType generic />
      - <@GenericInitialValue generic />
      - <#if comment?has_content><@IndentComment comment 3/><#elseif isPreview>
			<@AiComment "generic ${generic.getName()}" "${generic.getDeclarationLine()}" 3 />
		</#if>
    </#items>
</#list>


<#list ports>
.. list-table:: Ports
    :widths: 24 24 12 40
    :header-rows: 1
    :class: longtable
    
    * - Name
      - Type
      - Direction
      - Description
    <#items as port>
    <#assign comment=port.getComment()>
    <#assign link=port.getLinkToRef()>

        .. _${port.getID()}:
    * - <@TableCellName port />
      - <#if link?has_content >:ref:`${port.getPortType()} <${link}>`<#else>${port.getPortType()}</#if>
      - ${port.getDirection()}
      - <#if comment?has_content><@IndentComment comment 3/><#elseif isPreview>
			<@AiComment "port ${port.getName()}" "${port.getDeclarationLine()}" 3 />
	  	</#if>
    </#items>
</#list>


<#list types>
.. list-table:: Types
    :widths: 50 50
    :header-rows: 1
    :class: longtable
    
    * - Name
      - Description
    <#items as type>
    <#assign comment=type.getComment()>

	    .. _${type.getID()}:
    * - <@TableCellName type />
      - <#if comment?has_content><@IndentComment comment 3/><#elseif isPreview>
			<@AiComment "type ${type.getName()}" "${type.getDeclarationLine()}" 3 />
	  	</#if>
    </#items>
</#list>


<#if functions?has_content>
	<@FunctionsList "Functions" functions isPreview />
</#if>

<#if procedures?has_content>
	<@FunctionsList "Procedures" procedures isPreview />
</#if>

<#list architectures>
<#if isPreview>
Architectures
	<#items as architecture>
 	* Architecture ${architecture.getName()} of ${architecture.getEntityName()}
	</#items>
<#else>
.. toctree:: 
   :maxdepth: 0
	
	<#items as architecture>
   ${unformatedname}/${architecture.getName()}
	</#items>
</#if>
</#list>

<#if format == "html">
.. raw:: html

	<div id="myModal" class="modal">
	  <span class="close">&times;</span>
	  <div id="img" class="modal-content"></div>
	</div>
</#if>