<#include "utils.${format}.ftl">

<@SectionTitle "Checks" true/>

<#list checks>
.. list-table::
	:widths: 40 60
	:header-rows: 1
	:class: longtable nowrap

	* - Name
	  - Description
	<#items as check>
	<#assign comment=check.getComment()>
	<#assign link=check.getLinkToRef()>
	<#assign enclosingStruct=check.getEnclosingStruct()>
	<#assign unitWithCheck=enclosingStruct + "." + check.getFormatedName()>
	
	<#assign enclosingPackage=check.getEnclosingPackage()>
	<#assign packageLink=check.getPackageLink()>
	<#assign packageWithLink=(packageLink?has_content)?then(":ref:`${enclosingPackage} <${packageLink}>`", "${enclosingPackage}")>
	
	* - ${packageWithLink} :: <#if link?has_content>:ref:`${unitWithCheck} <${link}>`<#else>${unitWithCheck}</#if>
	  - <#if comment?has_content><@IndentComment comment 3 /></#if>
	</#items>
</#list>
