<#include "utils.${format}.ftl">
Macros
=======

<#list definedControlDefines>
.. list-table:: Defined Control Defines
	:widths: 45 55
	:header-rows: 1
	:class: longtable
	
	* - Name
	  - Description
	
	<#items as macro>
	<#assign comment=macro.getComment()>
	* - ${macro.getFormatedName()}
	  - <#if comment?has_content><@IndentComment comment 3/></#if>
	</#items>
</#list>

<#list undefinedControlDefines>
.. list-table:: Undefined Control Defines
	:widths: 45 55
	:header-rows: 1
	:class: longtable
	
	* - Name
	  - Description
	
	<#items as macro>
	<#assign comment=macro.getComment()>
	* - ${macro.getFormatedName()}
	  - <#if comment?has_content><@IndentComment comment 3/></#if>
	</#items>
</#list>

<#list defines>
.. list-table:: Defines
	:widths: 35 20 45
	:header-rows: 1
	:class: longtable
	
	* - Name
	  - Value
	  - Description
	
	<#items as macro>
	<#assign comment=macro.getComment()>
	* - ${macro.getFormatedName()}
	  - ${macro.getValue()}
	  - <#if comment?has_content><@IndentComment comment 3/></#if>
	</#items>
</#list>

<#list ifndefGuards>
.. list-table:: Ifndef Guards
	:widths: 45 55
	:header-rows: 1
	:class: longtable
	
	* - Name
	  - Description
	
	<#items as macro>
	<#assign comment=macro.getComment()>
	* - ${macro.getName()}
	  - <#if comment?has_content><@IndentComment comment 3/></#if>
	</#items>
</#list>

<#if preprocessing?has_content>
.. list-table:: Preprocessing
	:widths: 35 20 45
	:header-rows: 1
	:class: longtable
	
	* - Name
	  - Value
	  - Description
	
	<#list preprocessing as macro>
	<#assign comment=macro.getComment()>
	* - ${macro.getName()}
	  - ${macro.getValue()}
	  - <#if comment?has_content><@IndentComment comment 3/></#if>
	</#list>
</#if>

<#if statement?has_content>
.. list-table:: Statements
	:widths: 20 35 45
	:header-rows: 1
	:class: longtable
	
	* - Name
	  - Value
	  - Description
	
	<#list statement as macro>
	<#assign comment=macro.getComment()>
	* - ${macro.getName()}
	  - .. code-block::
	  
	        ${macro.getValue()}
	  - <#if comment?has_content><@IndentComment comment 3/></#if>
	</#list>
</#if>

<#if struct_member?has_content>
.. list-table:: Struct Members
	:widths: 20 35 45
	:header-rows: 1
	:class: longtable
	
	* - Name
	  - Value
	  - Description
	
	<#list struct_member as macro>
	<#assign comment=macro.getComment()>
	* - ${macro.getName()}
	  - .. code-block::
	  
	        ${macro.getValue()}
	  - <#if comment?has_content><@IndentComment comment 3/></#if>
	</#list>
</#if>

<#if action?has_content>
.. list-table:: Actions
	:widths: 20 35 45
	:header-rows: 1
	:class: longtable
	
	* - Name
	  - Value
	  - Description
	
	<#list action as macro>
	<#assign comment=macro.getComment()>
	* - ${macro.getName()}
	  - .. code-block::
	  
	        ${macro.getValue()}
	  - <#if comment?has_content><@IndentComment comment 3/></#if>
	</#list>
</#if>

<#if cover_item?has_content>
.. list-table:: Cover Items
	:widths: 20 35 45
	:header-rows: 1
	:class: longtable
	
	* - Name
	  - Value
	  - Description
	
	<#list cover_item as macro>
	<#assign comment=macro.getComment()>
	* - ${macro.getName()}
	  - ${macro.getValue()}
	  - <#if comment?has_content><@IndentComment comment 3/></#if>
	</#list>
</#if>

<#if type?has_content>
.. list-table:: Types
	:widths: 20 35 45
	:header-rows: 1
	:class: longtable
	
	* - Name
	  - Value
	  - Description
	
	<#list type as macro>
	<#assign comment=macro.getComment()>
	* - ${macro.getName()}
	  - .. code-block::
	  
	        ${macro.getValue()}
	  - <#if comment?has_content><@IndentComment comment 3/></#if>
	</#list>
</#if>

<#if exp?has_content>
.. list-table:: Expressions
	:widths: 20 35 45
	:header-rows: 1
	:class: longtable
	
	* - Name
	  - Value
	  - Description
	
	<#list exp as macro>
	<#assign comment=macro.getComment()>
	* - ${macro.getName()}
	  - .. code-block::
	  
	        ${macro.getValue()}
	  - <#if comment?has_content><@IndentComment comment 3/></#if>
	</#list>
</#if>

<#if command?has_content>
.. list-table:: Commands
	:widths: 20 35 45
	:header-rows: 1
	:class: longtable
	
	* - Name
	  - Value
	  - Description
	
	<#list command as macro>
	<#assign comment=macro.getComment()>
	* - ${macro.getName()}
	  - .. code-block::
	  
	        ${macro.getValue()}
	  - <#if comment?has_content><@IndentComment comment 3/></#if>
	</#list>
</#if>

<#if format == "html">
.. raw:: html

	<div id="myModal" class="modal">
	  <span class="close">&times;</span>
	  <div id="img" class="modal-content"></div>
	</div>
</#if>