<#include "utils.${format}.ftl">
<#if hasCode>
<@LinkToCode declaration line />
</#if>

.. _${id}:
	
Interface ${name}
${""?left_pad(("Interface " + name)?length, "*")}
<#if format == "pdf">
.. raw:: latex

	\label{${id}}
</#if>

<#if hasBlockDiagram>
<@CopyButton unformatedname parameters ports "Block Diagram of ${unformatedname}" >
<@Diagram "block_of_${unformatedname}.svg" "Block Diagram of ${unformatedname}" />
</@CopyButton>		
</#if>

<#if comment?? && comment?has_content>
  <@Comment comment=comment />
<#elseif isPreview>
  <@AiComment "interface" commentLine 0 true/>
</#if>

<#list parameters>
.. list-table:: Parameters
	:widths: 24 24 52
	:header-rows: 1
	:class: longtable
    
	* - Name
	  - Default value
	  - Description
	<#items as parameter>
	<#assign comment=parameter.getComment()>

	    .. _${parameter.getID()}:
	* - <@TableCellName parameter />
	  - ${parameter.getValue()}
	  - <#if comment?has_content><@TableComment comment /><#elseif isPreview>
			<@AiComment "parameter ${parameter.getName()}=${parameter.getValue()}" "${parameter.getDeclarationLine()}" 3 />
	  	</#if>
	</#items>
</#list>

<#list localparams>
.. list-table:: Local Parameters
	:widths: 24 24 52
	:header-rows: 1
	:class: longtable
    
	* - Name
	  - Default value
	  - Description
	<#items as parameter>
	<#assign comment=parameter.getComment()>

	    .. _${parameter.getID()}:
	* - <@TableCellName parameter />
	  - ${parameter.getValue()}
	  - <#if comment?has_content><@TableComment comment /><#elseif isPreview>
			<@AiComment "parameter ${parameter.getName()}=${parameter.getValue()}" "${parameter.getDeclarationLine()}" 3 />
	  	</#if>	
	</#items>
</#list>

<#list ports>
.. list-table:: Ports
	:widths: 24 24 12 40
	:header-rows: 1
	:class: longtable

	* - Name
	  - Type
	  - Direction
	  - Description
	<#items as port>
	<#assign comment=port.getComment()>
	
	    .. _${port.getID()}:
	* - <@TableCellName port />
	  - <@TypeWithLinks port true />
	  - ${port.getDirection()}
	  - <#if comment?has_content><@TableComment comment /><#elseif isPreview>
			<@AiComment "port ${port.getDirection()} ${port.getType()} ${port.getName()}" "${port.getDeclarationLine()}" 3 />
	  	</#if>
	</#items>
</#list>

<#list variables>
.. list-table:: Signals
	:widths: 24 24 52
	:header-rows: 1
	:class: longtable
	
	* - Name
	  - Type
	  - Description
	<#items as variable>
	<#assign comment=variable.getComment()>

	    .. _${variable.getID()}:
	* - <@TableCellName variable />
	  - <@TypeWithLinks variable false />
	  - <#if comment?has_content><@IndentComment comment 3/><#elseif isPreview>
			<@AiComment "variable ${variable.getName()}" "${variable.getDeclarationLine()}" 3 />
	  </#if>
	</#items>
</#list>

<#if assertions?has_content>
	<@AssertionsTable "Assertions" assertions isPreview/>
</#if>

<#if modports?has_content>
	<@Modport "Modports" modports />
</#if>

<#if clockingBlocks?has_content>
	<@MemberList "Clocking Blocks" clockingBlocks isPreview />
</#if>

<#if events?has_content>
	<@MemberList "Events" events isPreview />
</#if>

<#if functions?has_content>
	<@FunctionsList "Functions" functions isPreview />
</#if>

<#if tasks?has_content>
	<@FunctionsList "Tasks" tasks isPreview />
</#if>

<#if instances?has_content>

<@SectionTitle "Instances" /> 

.. raw:: html

	<div id="instances">

<#assign top=instances["top"][0]>
* ${top.getName()} <@LinkToInstance top />
<@Instances top.getID() 0 />

.. raw:: html

	</div>
</#if>

<#if format == "pdf">
.. raw:: latex

	\clearpage
<#else>
.. raw:: html

	<div id="myModal" class="modal">
	  <span class="close">&times;</span>
	  <div id="img" class="modal-content"></div>
	</div>
</#if>
	