<#include "utils.${format}.ftl">
	
<#if showTitle>
Library ${name}<#if language??> [${language}]</#if>
${""?left_pad(("Library " + name)?length, "*")}<#if language??>${""?left_pad((" [" + language + "]")?length, "*")}</#if>
</#if>

<#if modules?has_content>
<#list modules>
Modules
-------

.. toctree:: 
   :maxdepth: 1
	
	<#items as module>
   modules/${module.getName()}.rst
	</#items>
</#list>
</#if>

<#if interfaces?has_content>
<#list interfaces>
Interfaces
----------

.. toctree:: 
   :maxdepth: 1
	
	<#items as interface>
   interfaces/${interface.getName()}.rst
	</#items>
</#list>
</#if>



<#if entities?has_content>
<#list entities>
Entities
--------

.. toctree:: 
   :maxdepth: 1
	
	<#items as entity>
   ${entity.getName()}.rst
	</#items>
</#list>
</#if>

<#if packages?has_content>
<#list packages>
Packages
--------

.. toctree:: 
   :maxdepth: 1
	
	<#items as package>
   <#if verilog?? && verilog>packages/${package.getName()}/${package.getDocumentationName()}<#else>${package.getName()}</#if>.rst
	</#items>
</#list>
</#if>


<#if classes?has_content>
<#list classes>
Classes
-------

.. toctree:: 
   :maxdepth: 1
	
	<#items as class>
   Class ${class.getName()} <classes/${class.getName()}.rst>
	</#items>
</#list>
</#if>


<#if typedefs?has_content>
<#if misc??>
Typedefs
--------
</#if>
<#list typedefs>
.. list-table:: <#if !misc??>Typedefs</#if>
	:widths: 25 25 50
	:header-rows: 1

	* - Name
	  - Actual Type
	  - Description
	<#items as typedef>
	<#assign comment=typedef.getComment()>
	<#assign link=typedef.getLinkToRefType()>

	    .. _${typedef.getID()}:
	* - <@TableCellName typedef />
	  - <#if link?has_content > :ref:`${typedef.getAssociatedTypeSignature()} <${link}>` <#else> ${typedef.getAssociatedTypeSignature()} </#if>
	  - <#if comment?has_content><@TableComment comment /></#if>
	</#items>
</#list>
</#if>

<#if enums?has_content>   
	<@EnumList "Enums" enums false true />
</#if>

<#if structs?has_content>   
	<#if structsIndexes?has_content>
Structs
-------

	<#list structs as struct>
* :ref:`${struct.getName()}<${struct.getID()}>`
	</#list>
	
	<#else>
	<@StructsList "Structs" structs false true/>
	</#if>
</#if>

<#if events?has_content>   
	<@MemberList "Events" events true/>
</#if>

<#if functions?has_content>
	<@FunctionsList "Functions" functions false false true/>
</#if>

<#if DPIexports?has_content>
	<@FunctionsList "DPI Export Functions" DPIexports false false true/>
</#if>

<#if DPIimports?has_content>
	<@FunctionsList "DPI Import Functions" DPIimports false false true/>
</#if>

<#if tasks?has_content>
	<@FunctionsList "Tasks" tasks false false true/>
</#if>