<#include "utils.${format}.ftl">
<#if hasCode>
<@LinkToCode declaration line />
</#if>

.. _${id}:
	
Module ${name}
${""?left_pad(("Module " + name)?length, "*")}
<#if format == "pdf">
.. raw:: latex

	\label{${id}}
</#if>

<#if hasBlockDiagram>
<@CopyButton "${id}-block" parameters ports "Block Diagram of ${unformatedname}" >
<@Diagram "block_of_${unformatedname}.svg" "Block Diagram of ${unformatedname}"/>
</@CopyButton>	
</#if>

<#if comment?? && comment?has_content>
  <@Comment comment=comment />
<#elseif isPreview>
  <@AiComment "module" commentLine 0 true/>
</#if>

<#if classes?has_content>
<#list classes>
Classes
-------

.. toctree:: 
   :maxdepth: 1
	
	<#items as class>
   Class ${class.getName()} <${unformatedname}/${class.getName()}>
	</#items>
</#list>
</#if>

<#list parameters>
.. list-table:: Parameters
	:widths: 24 24 52
	:header-rows: 1
	:class: longtable

	* - Name
	  - Default
	  - Description
    <#items as parameter>
    <#assign comment=parameter.getComment()>
    
	    .. _${parameter.getID()}:
	* - <@TableCellName parameter />
	  - ${parameter.getValue()}
	  - <#if comment?has_content><@TableComment comment /><#elseif isPreview>
			<@AiComment "parameter ${parameter.getName()}=${parameter.getValue()}" "${parameter.getDeclarationLine()}" 3 />
		</#if>
	</#items>
</#list>

<#list localparams>
.. list-table:: Local Parameters
	:widths: 24 24 52
	:header-rows: 1
	:class: longtable

	* - Name
	  - Default
	  - Description
    <#items as parameter>
    <#assign comment=parameter.getComment()>
    
	    .. _${parameter.getID()}:
	* - <@TableCellName parameter />
	  - ${parameter.getValue()}
	  - <#if comment?has_content><@TableComment comment /><#elseif isPreview>
	  		
			<@AiComment "parameter ${parameter.getName()}=${parameter.getValue()}" "${parameter.getDeclarationLine()}" 3 />
			
	  	</#if>	
	</#items>
</#list>

<#list ports>
.. list-table:: Ports
	:widths: 24 24 12 40
	:header-rows: 1
	:class: longtable
    
	* - Name
	  - Type
	  - Direction
	  - Description
	<#items as port>
	<#assign type><@compress single_line = true><@TypeWithLinks port true /></@compress></#assign>
	<#assign direction>${port.getDirection()}</#assign>
	<#assign comment=port.getComment()>
	
	    .. _${port.getID()}:
	* - <@TableCellName port />
	  - ${type}
	  - ${direction}
	  - <#if comment?has_content><@TableComment comment /><#elseif isPreview>
	  
			<@AiComment "port ${direction} ${type} ${port.getName()}" "${port.getDeclarationLine()}" 3 />
	  	</#if>
	</#items>
</#list>

<#list variables>
.. list-table:: Variables
	:widths: 24 24 52
	:header-rows: 1
	:class: longtable
	
	* - Name
	  - Type
	  - Description
	<#items as variable>
	<#assign comment=variable.getComment()>
	<#assign type><@TypeWithLinks variable false /></#assign>
	
	    .. _${variable.getID()}:
	* - <@TableCellName variable />
	  - ${type}
	  - <#if comment?has_content><@IndentComment comment 3/><#elseif isPreview>
	  
			<@AiComment "variable ${variable.getName()}" "${variable.getDeclarationLine()}" 3 />
	  </#if>
	</#items>
</#list>

<#list typedefs>
.. list-table:: Typedefs
	:widths: 24 24 52
	:header-rows: 1
	:class: longtable

	* - Name
	  - Actual Type
	  - Description
	<#items as typedef>
	<#assign comment=typedef.getComment()>
	<#assign link=typedef.getLinkToRefType()>

	    .. _${typedef.getID()}:
	* - <@TableCellName typedef />
	  - <#if link?has_content > :ref:`${typedef.getAssociatedTypeSignature()} <${link}>` <#else> ${typedef.getAssociatedTypeSignature()} </#if>
	  - <#if comment?has_content><@TableComment comment /><#elseif isPreview>
	  
<#nt>			<@AiComment "typedef ${typedef.getName()} ${typedef.getAssociatedTypeSignature()}" "${typedef.getDeclarationLine()}" />
	  	</#if>
	</#items>
</#list>

<#if assertions?has_content>
	<@AssertionsTable "Assertions" assertions isPreview />
</#if>

<#if structs?has_content>   
	<@StructsList "Structs" structs isPreview />
</#if>


<#list alwaysBlocks>

<@SectionTitle "Always Blocks" /> 

.. raw:: html

	<section id="always-blocks">
<#assign count = 0>
	
<#items as alwaysBlock>
	<@AlwaysBlock alwaysBlock alwaysBlock?index isPreview />
<#if alwaysBlock.containsFSMDiagram()>

.. container:: diagram fsm
    :name: ${id}-fsm-${alwaysBlock.getFSMDiagramVariableName()}

<@Diagram alwaysBlock.getFSMDiagramName() /> 
<@ZoomButtons />

<#assign commonExpressions = alwaysBlock.getCommonExpressions()!"">
<#if commonExpressions?has_content >
.. note::
	
	Common expressions filtered by preference: <#list commonExpressions as expression>${expression}<#sep> && </#sep></#list> 
</#if>
<#assign rows = alwaysBlock.getRows()!"">
.. list-table:: FSM Transitions for ${alwaysBlock.getFSMDiagramVariableName()}
	:widths: 7 19 19 35 20
	:header-rows: 1
	:name: ${name}_fsm_table_${count}
	:class: longtable table-hover

	* - #
	  - Current State
	  - Next State
	  - Condition
	  - Comment
	<#list rows as row>
	<#assign comment=row.getTransitionComment()>
	
	* - ${row.getTransitionIndex()}
	  - ${row.getCurrentState()}
	  - ${row.getNextState()}
	  - ${row.getCondition()}
	  - <#if comment?has_content><@IndentComment comment 3/><#elseif isPreview>
	  
		<@AiComment "fsm-transition ${row.getCurrentState()} ${row.getNextState()} ${row.getCondition()}" "${row.getCommentLine()}" 3 />
	  </#if>
	</#list>	
<#assign count++ >
	
</#if>
</#items>

.. raw:: html

	</section>
</#list>

<#if clockingBlocks?has_content>
	<@MemberList "Clocking Blocks" clockingBlocks isPreview />
</#if>

<#if events?has_content>
	<@MemberList "Events" events isPreview />
</#if>

<#if functions?has_content>
	<@FunctionsList "Functions" functions isPreview />
</#if>

<#if tasks?has_content>
	<@FunctionsList "Tasks" tasks isPreview />
</#if>

<#if instances?has_content && !isDesignTop>

<@SectionTitle "Instances" /> 

.. raw:: html

	<div id="instances">

<#assign top=instances["top"][0]>
* ${top.getName()} <@LinkToInstance top />
<@Instances top.getID() 0 />

.. raw:: html

	</div>

</#if>

<#if submodules?has_content || hasSchematicDiagram || hasSubInstancesDiagram || hasFlowDiagram>
<@SectionTitle "Submodules" />

.. raw:: html

	<div id="submodules">

<@SubInstances submodules/>

.. raw:: html

	</div>

<#if hasFlowDiagram>
<@ExpandButton "${id}-flow" "flow" "Flow Diagram of ${unformatedname}">
<@Diagram "flow_of_${unformatedname}.svg" "Flow Diagram of ${unformatedname}"/>
</@ExpandButton>  
</#if>

<#if hasSubInstancesDiagram>
<@ExpandButton "${id}-subinstances" "subinstances" "Sub-Instances Diagram of ${unformatedname}">
<@Diagram "subinstances_of_${unformatedname}.svg" "Sub-Instances Diagram of ${unformatedname}"/>
</@ExpandButton>  
</#if>

<#if hasSchematicDiagram>
<@ExpandButton "${id}-schematic" "schematic" "Schematic Diagram of ${unformatedname}">
<@Diagram "schematic_of_${unformatedname}.svg" "Schematic Diagram of ${unformatedname}"/>
</@ExpandButton>  
</#if>
</#if>

<#if format == "pdf">
.. raw:: latex

	\clearpage
<#else>
.. raw:: html

	<div id="myModal" class="modal">
	  <span class="close">&times;</span>
	  <div id="img" class="modal-content"></div>
	</div>
</#if>
