<#include "utils.${format}.ftl">
<#if hasCode && declaration??>
	<@LinkToCode declaration declarationLine />
</#if>

.. _${id}:

Package ${name}
${""?left_pad(("Package " + name)?length, "*")}
<#if format == "pdf">
.. raw:: latex

	\label{${id}}
</#if>

<#if comment?has_content>
<@Comment comment />
</#if>

<#if classes?has_content>
<#list classes>
Classes
-------
.. toctree:: 
   :maxdepth: 1
	
	<#items as class>
   Class ${class.getName()} <${class.getName()}>
	</#items>
</#list>
</#if>

<#if structures?has_content>
Structs
-------
.. toctree:: 
   :maxdepth: 1
	
	<#list structures as struct>
   ${struct.getName()}
	</#list>
</#if>

<#if units?has_content>
Units
-----
.. toctree:: 
   :maxdepth: 1
	
	<#list units as unit>
   ${unit.getName()}
	</#list>
</#if>

<#if sequences?has_content>
Sequences
---------
.. toctree:: 
   :maxdepth: 1
	
	<#list sequences as sequence>
   ${sequence.getName()}
	</#list>
</#if>

<#if components?has_content>
<#list components>
Components
----------

.. toctree:: 
   :maxdepth: 1

	<#items as component>
   ${unformatedname}/${component.getName()}
	</#items>
</#list>
</#if>

<#if typedefs?has_content>
<#list typedefs>
.. list-table:: Typedefs
	:widths: 25 25 50
	:header-rows: 1

	* - Name
	  - Actual Type
	  - Description
	<#items as typedef>
	<#assign comment=typedef.getComment()>
	<#assign link=typedef.getLinkToRefType()>

	    .. _${typedef.getID()}:
	* - <@TableCellName typedef />
	  - <#if link?has_content > :ref:`${typedef.getAssociatedTypeSignature()} <${link}>` <#else> ${typedef.getAssociatedTypeSignature()} </#if>
	  - <#if comment?has_content><@TableComment comment /></#if>
	</#items>
</#list>
</#if>

<#if parameters?has_content>
<#list parameters>
.. list-table:: Parameters
	:widths: 25 25 50
	:header-rows: 1
	:class: longtable

	* - Name
	  - Default value
	  - Description
	<#items as parameter>
	<#assign comment=parameter.getComment()>
	
	    .. _${parameter.getID()}:
	* - <@TableCellName parameter />		
	  - ${parameter.getValue()}
	  - <#if comment?has_content><@TableComment comment /></#if>
	</#items>
</#list>
</#if>

<#if localparams?has_content>
<#list localparams>
.. list-table:: Local Parameters
	:widths: 25 25 50
	:header-rows: 1
	:class: longtable

	* - Name
	  - Default value
	  - Description
	<#items as parameter>
	<#assign comment=parameter.getComment()>
	
	    .. _${parameter.getID()}:
	* - <@TableCellName parameter />		
	  - ${parameter.getValue()}
	  - <#if comment?has_content><@TableComment comment /></#if>
	</#items>
</#list>
</#if>

<#if variables?has_content>
<#list variables>
.. list-table:: Variables
	:widths: 25 25 50
	:header-rows: 1
	:class: longtable
	
	* - Name
	  - Type
	  - Description
	<#items as variable>
	<#assign comment=variable.getComment()>
	
	    .. _${variable.getID()}:
	* - <@TableCellName variable />
	  - <@TypeWithLinks variable false />
	  - <#if comment?has_content><@IndentComment comment 3/></#if>
	</#items>
</#list>
</#if>

<#if enums?has_content>   
	<@EnumList "Enums" enums false true/>
</#if>

<#if structs?has_content>   
	<#if structsIndexes?has_content>
Structs
-------

	<#list structs as struct>
* :ref:`${struct.getName()}<${struct.getID()}>`
	</#list>
	
	<#else>
	<@StructsList "Structs" structs false true/>
	</#if>
</#if>


<#if constants?has_content>
<#list constants>
.. list-table:: Constants
	:widths: 25 25 50
	:header-rows: 1
	:class: longtable

	* - Name
	  - Value
	  - Description
	<#items as constant>
	<#assign comment=constant.getComment()>
	
	    .. _${constant.getID()}:
	* - <@TableCellName constant />
	  - ${constant.getInitialValue()}
	  - <#if comment?has_content><@TableComment comment /></#if>
	</#items>
</#list>
</#if>


<#if types?has_content>
<#list types>
.. list-table:: Types
	:widths: 50 50
	:header-rows: 1
	:class: longtable

	* - Name
	  - Description
	<#items as type>
	<#assign comment=type.getComment()>

	    .. _${type.getID()}:
	* - <@TableCellName type />
	  - <#if comment?has_content><@TableComment comment /></#if>
	</#items>
</#list>
</#if>

<#if scalars?has_content>   
	<@EnumList "Scalars" scalars false true />
</#if>

<#if events?has_content>   
	<@MemberList "Events" events true/>
</#if>

<#if functions?has_content>
	<@FunctionsList "Functions" functions false false true />
</#if>

<#if DPIexports?has_content>
	<@FunctionsList "DPI Export Functions" DPIexports false false true />
</#if>

<#if DPIimports?has_content>
	<@FunctionsList "DPI Import Functions" DPIimports false false true />
</#if>

<#if tasks?has_content>
	<@FunctionsList "Tasks" tasks false false true />
</#if>

<#if procedures?has_content>
	<@FunctionsList "Procedures" procedures false false true/>
</#if>

<#if format == "pdf">
.. raw:: latex

	\clearpage
<#else>
.. raw:: html

	<div id="myModal" class="modal">
	  <span class="close">&times;</span>
	  <div id="img" class="modal-content"></div>
	</div>
</#if>