<#include "utils.${format}.ftl">
<#if hasCode>
<@LinkToCode declaration line />
</#if>

.. _${id}:

Test ${name}
${""?left_pad(("Test " + name)?length, "*")}
<#if format == "pdf">
.. raw:: latex

	\label{${id}}
</#if>

<#if comment?has_content>
<@Comment comment />
<#elseif (isPreview!false)>
  <@AiComment "test" commentLine 0 true/>
</#if>

<#list subtypes>

.. list-table:: When Subtypes
	:widths: 48 52
	:header-rows: 1
	:class: longtable nowrap when-subtypes

	* - Name
	  - Description
	<#items as subtype>
	<#assign comment=subtype.getComment()>
	<#assign qualifiers = subtype.getQualifiers()>
	
	    .. _${subtype.getID()}:
	* - <#list qualifiers?keys as qualifier>
	    .. cssclass:: subtype
	    
	    		<#if qualifiers[qualifier]?has_content>
	       :ref:`${qualifier} <${qualifiers[qualifier]}>`
	   			<#else>
	   	   :guilabel:`${qualifier}`
   				</#if>
		</#list>
	    
    <#if subtype.structHasLink()>
	    :ref:`${subtype.getStruct().getName()} <${subtype.getStruct().getID()}>`
    <#else>
	    ${subtype.getStruct().getName()}
	</#if>
	  - <#if comment?has_content><@IndentComment comment 3/></#if>
	</#items>
</#list>

<#if structures?has_content>
Structs
-------
.. toctree:: 
   :maxdepth: 1
	
	<#list structures as struct>
   ${struct.getName()}
	</#list>
</#if>

<#if units?has_content>
Units
-----
.. toctree:: 
   :maxdepth: 1
	
	<#list units as unit>
   ${unit.getName()}
	</#list>
</#if>

<#if sequences?has_content>
Sequences
---------
.. toctree:: 
   :maxdepth: 1
	
	<#list sequences as sequence>
   ${sequence.getName()}
	</#list>
</#if>

<#if scalars?has_content>   
	<@EnumList "Scalars" scalars false />
</#if>

<#if format == "pdf">
.. raw:: latex

	\clearpage
<#else>
.. raw:: html

	<div id="myModal" class="modal">
	  <span class="close">&times;</span>
	  <div id="img" class="modal-content"></div>
	</div>
</#if>