<#include "utils.${format}.ftl">
<#if hasCode>
<@LinkToCode declaration line />
</#if>

.. _${id}:

${type} ${name}
${""?left_pad((type + " " + name)?length, "*")}
<#if format == "pdf">
.. raw:: latex

	\label{${id}}
</#if>

<#list structHierarchy>
.. raw:: html

	<div id="class-hierarchy">

<#assign indent = 0>	
<#items as struct>
${"*"?left_pad(indent * 3 + 1, " ")} ${struct}
<#assign indent++>
</#items>

.. raw:: html

	</div>
</#list>

<#if hasUMLDiagram>
<@ExpandButton "${id}-uml" "inheritance" "Inheritance Diagram of ${unformatedname}">
<@Diagram "uml_of_${unformatedname}.svg" "Inheritance Diagram of ${unformatedname}"/>
</@ExpandButton>  
</#if>

<#if hasUMLCollaborationDiagram>
<@ExpandButton "${id}-collaboration" "collaboration" "Collaboration Diagram of ${unformatedname}">
<@Diagram "collaboration_of_${unformatedname}.svg" "Collaboration Diagram of ${unformatedname}"/>
</@ExpandButton>  
</#if>

<#if comment?has_content>
<@Comment comment />
<#elseif isPreview>
<@AiComment "unit" commentLine 0 true/>
</#if>

<#list subtypes>
.. list-table:: When Subtypes
	:widths: 24 76
	:header-rows: 1
	:class: longtable nowrap	

	* - Name
	  - Description
	<#items as subtype>
	<#assign comment=subtype.getComment()>
	<#assign qualifiers = subtype.getQualifiers()>
	
	    .. _${subtype.getID()}:
	* - <#if qualifiers?has_content><#list qualifiers?keys as qualifier><#if qualifiers[qualifier]?has_content>:ref:`${qualifier} <${qualifiers[qualifier]}>`<#else>${qualifier}</#if> </#list><#else>${subtype.getName()}</#if>
	  - <#if comment?has_content><@IndentComment comment 3/><#elseif isPreview>
			<@AiComment "subtype ${subtype.getName()}" "${subtype.getDeclarationLine()}" 3 />
		</#if>
	</#items>
</#list>

<#list fields>
.. list-table:: Fields
	:widths: 24 18 18 40
	:header-rows: 1
	:class: longtable nowrap

	* - Name
	  - When Subtype
	  - Type
	  - Description
	<#items as field>
	<#assign comment=field.getComment()>
	<#assign link=field.getLinkToRefType()>
	<#assign linkToSubtype=field.getLinkToSubtype()>
	
	    .. _${field.getID()}:
	* - <@TableCellName field />
	  - <#if linkToSubtype?has_content> :ref:`${field.getDeterminant()?replace(unformatedname, "")} <${linkToSubtype}>`<#else>${field.getDeterminant()?replace(unformatedname, "")}</#if>
	  - <#if link?has_content> :ref:`${field.getAssociatedTypeName()} <${link}>` <#else> ${field.getAssociatedTypeName()} </#if>
	  - <#if comment?has_content><@IndentComment comment 3/><#elseif isPreview>
			<@AiComment "field ${field.getName()}" "${field.getDeclarationLine()}" />
		</#if>
	</#items>
</#list>

<#list ports>
.. list-table:: Ports
	:widths: 24 18 18 40
	:header-rows: 1
	:class: longtable nowrap

	* - Name
	  - When Subtype
	  - Type
	  - Description
	<#items as port>
	<#assign comment=port.getComment()>
	<#assign linkToSubtype=port.getLinkToSubtype()>
	
	    .. _${port.getID()}:
	* - <@TableCellName port />
	  - <#if linkToSubtype?has_content> :ref:`${port.getDeterminant()?replace(unformatedname, "")} <${linkToSubtype}>`<#else>${port.getDeterminant()?replace(unformatedname, "")}</#if>
	  - ${port.getAssociatedTypeName()?replace("\n", " ")}
	  - <#if comment?has_content><@IndentComment comment 3/><#elseif isPreview>
			<@AiComment "port ${port.getName()}" "${port.getDeclarationLine()}" 3 />
	  	</#if>
	</#items>
</#list>

<#list checks>
.. list-table:: Checks
	:widths: 24 12 24 40 
	:header-rows: 1
	:class: longtable nowrap

	* - Name
	  - Type
	  - Expression
	  - Description
	<#items as check>
	<#assign comment=check.getComment()>
	<#if check.isAnonymous()>
	<#else>
	<#assign n=2>
	</#if>
	
	    <#if !check.isAnonymous()>.. _${check.getID()}:</#if>
	* - <#if !check.isAnonymous()><@TableCellName check /><#else>${check.getName()}</#if>
	  - ${check.getType()}
	  - ${check.getExpression()?replace("\n\\s+", "\n\t    ", 'r')}
	  - <#if comment?has_content><@IndentComment comment 3 /><#elseif isPreview>
			<@AiComment "check ${check.getName()}" "${check.getDeclarationLine()}" />
	  	</#if>
	</#items>
</#list>

<#if events?has_content>   
	<@CovergroupList "Events" events isPreview false />
</#if>

<#if extendedEvents?has_content>   
	<@ExtendedMembers "Extended Events" extendedEvents isPreview />
</#if>

<#if methods?has_content>   
	<@MethodList "Methods" methods isPreview />
</#if>

<#if extendedMethods?has_content>   
	<@MethodList "Extended Methods" extendedMethods isPreview />
</#if>

<#if TCMs?has_content>   
	<@MethodList "TCMs" TCMs isPreview />
</#if>

<#if extendedTCMs?has_content>   
	<@MethodList "Extended TCMs" extendedTCMs isPreview />
</#if>


<#if format == "pdf">
.. raw:: latex

	\clearpage
<#else>
.. raw:: html

	<div id="myModal" class="modal">
	  <span class="close">&times;</span>
	  <div id="img" class="modal-content"></div>
	</div>
</#if>