<#macro Align text indent>${text?replace('\n', '\n'?right_pad(indent + 1, '\t'))}</#macro>

<#macro IndentComment commentSegments indent>
<#list commentSegments as commentSegment>

<#switch commentSegment.getType()>
	<#case "title">
	<#case "text">
${""?left_pad((indent > 1)?then((indent > 3)?then(2, 1), 0), "\t")}<#if (indent - 1 > 1)>    </#if>.. raw:: html

${""?left_pad(indent, "\t")}<div class="comment" ${(isPreview!false)?then('data-raw="' + commentSegment.getRawContent()?js_string?html + '" data-start="' + commentSegment.getStartLine() + '" data-end="' + commentSegment.getEndLine() + '"', '')}><@Align commentSegment.getContent() indent/></div>
		<#break>
	<#case "custom_diagram">
	<#case "wavedrom">
<@ExpandButton "custom" "custom" "" indent>

${""?left_pad((indent > 1)?then((indent > 3)?then(2, 1), 0), "\t")}<#if (indent - 1 > 1)>    </#if>    .. image:: ${commentSegment.getContent()}
${""?left_pad((indent > 1)?then((indent > 3)?then(2, 1), 0), "\t")}<#if (indent - 1 > 1)>    </#if>        :align: center
${""?left_pad((indent > 1)?then((indent > 3)?then(2, 1), 0), "\t")}<#if (indent - 1 > 1)>    </#if>        :scale: 100%

</@ExpandButton>  
		<#break>
	<#case "code-block">
${""?left_pad((indent > 1)?then((indent > 3)?then(2, 1), 0), "\t")}<#if (indent - 1 > 1)>    </#if>.. code-block::
	
${""?left_pad(indent, "\t")}<@Align commentSegment.getContent() indent/>
		<#break>
	<#case "none">
${""?left_pad((indent > 1)?then((indent > 3)?then(2, 1), 0), "\t")}<#if (indent - 1 > 1)>    </#if>.. container:: verbatim-comment

${""?left_pad((indent > 1)?then((indent > 3)?then(2, 1), 0), "\t")}<#if (indent > 1)>    </#if><#if (indent - 1 > 1)>    </#if>.. highlight:: none

${""?left_pad((indent > 1)?then((indent > 3)?then(2, 1), 0), "\t")}<#if (indent > 1)>    </#if><#if (indent - 1 > 1)>    </#if>::
	
${""?left_pad(indent + 1, "\t")}<@Align commentSegment.getContent() indent + 1/>
		<#break>
	<#case "rst">
<#assign rstIndent>${'\n'?right_pad((indent > 1)?then((indent > 3)?then(3, 2), 1), "\t")}<#if (indent - 1 > 1)>    </#if></#assign>
${rstIndent}${commentSegment.getContent()?replace('\n', rstIndent)}
</#switch>

</#list>
</#macro>

<#macro Comment comment>
	<#assign addAdmonition = true>
	<#list comment as commentSegment>
		<#if commentSegment.getFormatName() == "rst" || commentSegment.getFormatName() == "markdown">
			<#assign addAdmonition = false>
		</#if>
	</#list>
	
	<#if addAdmonition>
.. admonition:: \ \

<#nt>	<@IndentComment comment 2 />
	<#else>
<@IndentComment comment 1 />		
	</#if>
</#macro>

<#macro TableComment comment indent=3>
<@IndentComment comment indent />
</#macro>

<#macro ElementHeader name id qualifiers="">
		<dt class="sig sig-object" id="${id}">
		<span class="sig-name descname pre">${qualifiers} <#nested> ${name}</span>
</#macro>

<#macro ElementLinkToCode element>
		<div class="code-link" style="display: none"><a class="reference internal" href="code/${element.getDeclarationLocation()}.html?${element.getDeclarationLine()}"><span class="viewcode-link"><span class="pre">[source]</span></span></a></div>
</#macro>

<#macro Permalink reference>
		<a class="headerlink" href="${reference}" title="Permalink to this definition"></a></dt>
</#macro>

<#macro TableCellName element>
.. raw:: html

			<div id="${element.getName()}">${element.getName()}</div>
</#macro>

<#macro MemberList Title elements isPreview=false addTitle=false>
<@SectionTitle Title addTitle/>
<#list elements as element>
<@Object element isPreview/>
</#list>
</#macro>

<#macro AlwaysBlock alwaysBlock index isPreview=false isProcess=false>
		
.. container:: always-block
	:name: ${alwaysBlock.getKind()}-${index}

	<#if alwaysBlock.hasCode()>
	.. raw:: html
		
		<div class="qualifiers" style="display: none">${alwaysBlock.getName()}</div>
		<#if hasCode><@ElementLinkToCode alwaysBlock /></#if>

	</#if>
	.. function:: <#if !isProcess>${alwaysBlock.getName()}</#if>${alwaysBlock.getType()} @(${alwaysBlock.getSensitivityList()})
	    	
		<#if alwaysBlock.getComment()?has_content><@IndentComment alwaysBlock.getComment() 3/><#elseif isPreview>
			<@AiComment "always-block" "${alwaysBlock.getDeclarationLine()}" 3 />
		</#if>
	
</#macro>

<#macro Modport Title elements>
<@SectionTitle Title />
<#list elements as element>

.. container:: member
	:name: ${element.getID()}
	
	<#if hasCode>
	.. raw:: html

		<@ElementLinkToCode element />
	</#if>
		
	<#assign portsList = element.getPortsList()>
	<#assign ports><@ModportArguments portsList /></#assign>
	.. function:: ${element.getName()}${ports?trim}
	    :no-index:
		
		<@IndentComment element.getComment() 3/>
		
	    <@PortsList portsList />

</#list>
</#macro>

<#macro ModportArguments portsList>
<#assign result="">
<#list portsList as port>
	<#assign result = "${result}${port.getAssociatedTypeName()} ${port.getName()}">
	<#assign result>${result}<#sep>, </#sep></#assign>
</#list>
(${result})
</#macro>

<#macro PortsList ports>
		 <#list ports as element>
	    :param ${element.getDirection()} ${element.getAssociatedTypeName()} ${element.getName()}: <@IndentComment element.getComment() 5 />
	    :type ${element.getName()}: ${element.getDirection()} <@TypeWithLinks element true />
	    </#list>
</#macro>

<#macro FunctionsList Title elements isPreview=false hasParent=false addTitle=false>
<@SectionTitle Title addTitle/>
<#list elements as element>
.. container:: member
	<#if !hasParent>:name: ${element.getID()}</#if>
	
	.. raw:: html

		<div class="qualifiers" style="display: none">${element.getQualifiers()} function ${element.getReturnTypeName()}</div>
		<#if hasCode><@ElementLinkToCode element /></#if>
		
	<#assign argumentsList = element.getFunctionArgumentsList()>
	<#assign comment = element.getComment()>
	<#assign arguments><@FunctionArguments argumentsList /></#assign>
	.. function:: ${element.getName()}${arguments?trim}
	    :no-index:
		
		<#if comment?has_content><@IndentComment comment 3/><#elseif isPreview>
			<@AiComment "function ${element.getName()} ${element.getReturnTypeName()}" "${element.getCommentLine()}" 3 true />
		</#if>
		
	    <@ArgumentsList argumentsList/>
	    <#assign returnTypeLink = element.getLinkToReturnType()>
	    <#if returnTypeLink?has_content>:rtype: :ref:`${element.getReturnTypeName()} <${returnTypeLink}>`</#if>	
	   	<#if hasParent>
		<#assign packageLink><#if element.getParentPackageName()?has_content><#if element.getLinkToPackage()?has_content>:ref:`${element.getParentPackageName()}<${element.getLinkToPackage()}>`<#else>${element.getParentPackageName()}</#if> :: </#if></#assign>
		<#assign parentStructLink><#if element.getParentName()?has_content><#if element.getLinkToParent()?has_content>:ref:`${element.getParentName()}<${element.getLinkToParent()}>`<#else>${element.getParentName()}</#if> . </#if></#assign>
		<#assign parentMethod><#if element.getLinkToParentMethod()?has_content>:ref:`${element.getName()}<${element.getLinkToParentMethod()}>`<#else>${element.getName()}</#if></#assign>
	    :Parent: ${packageLink}${parentStructLink}${parentMethod}
		</#if>

</#list>
</#macro>

<#macro FunctionArguments agumentsList>
<#assign result="">
<#list agumentsList as argument>
	<#assign result = "${result}${argument.getAssociatedTypeName()} ${argument.getName()}">
	<#assign initialValue = argument.getInitialValue()>
	<#if initialValue?has_content><#assign result="${result} = ${initialValue}"></#if>
	<#assign result>${result}<#sep>, </#sep></#assign>
</#list>
(${result})
</#macro>

<#macro MethodList Title elements isPreview=false>
<@SectionTitle Title addTitle/>
<#list elements as element>
.. container:: member
	:name: ${element.getID()}
	
	.. raw:: html
		
		<div class="qualifiers" style="display: none">${element.getDeterminant()} ${element.getQualifiers()}</div>
		<#if hasCode><@ElementLinkToCode element /></#if>
		
	<#assign argumentsList = element.getFunctionArgumentsList()>
	<#assign arguments><@FunctionArguments argumentsList /></#assign>
	<#assign comment=element.getComment()>
	.. function:: ${element.getName()}${arguments?trim}${element.getSamplingEvent()} : ${element.getReturnTypeName()}
	    :no-index:
		
		<#if comment?has_content><@IndentComment element.getComment() 3/><#elseif isPreview>
			<@AiComment "element.getKind() ${element.getName()}" "${element.getCommentLine()}" 3/>
		</#if>
		
	    <@ArgumentsList argumentsList/>
	    <#assign returnTypeLink = element.getLinkToReturnType()>
	    <#if returnTypeLink?has_content>:rtype: :ref:`${element.getReturnTypeName()} <${returnTypeLink}>`</#if>	
	    
	    <#assign eventUrl = element.getSamplingEventUrl()>
	    <#if eventUrl?has_content>:Sampling Event: :ref:`${element.getSamplingEvent()}<${eventUrl}>`</#if>
	    
	    <#if element.hasParent()>
		<#assign packageLink><#if element.getParentPackageName()?has_content>:ref:`${element.getParentPackageName()}<${element.getLinkToPackage()}>`<#else>${element.getParentPackageName()}</#if> :: </#assign>
		<#assign parentStructLink><#if element.getLinkToParent()?has_content>:ref:`${element.getParentName()}<${element.getLinkToParent()}>`<#else>${element.getParentName()}</#if> . </#assign>
		<#assign parentMethod><#if element.getLinkToParentMethod()?has_content>:ref:`${element.getName()}<${element.getLinkToParentMethod()}>`<#else>${element.getName()}</#if></#assign>
	    :Parent: ${packageLink}${parentStructLink}${parentMethod}
		</#if>
</#list>
</#macro>

<#macro ExtendedMembers Title elements isPreview=false>

<@SectionTitle Title />
<#list elements as element>

<@Object element isPreview/>

		<#if element.hasParent()>
		<#assign packageLink><#if element.getParentPackageName()?has_content>:ref:`${element.getParentPackageName()}<${element.getLinkToPackage()}>`<#else>${element.getParentPackageName()}</#if> :: </#assign>
		<#assign parentStructLink><#if element.getLinkToParent()?has_content>:ref:`${element.getParentName()}<${element.getLinkToParent()}>`<#else>${element.getParentName()}</#if> . </#assign>
		<#assign parentEvent><#if element.getLinkToParentEvent()?has_content>:ref:`${element.getName()}<${element.getLinkToParentEvent()}>`<#else>${element.getName()}</#if></#assign>
	    :Parent: ${packageLink}${parentStructLink}${parentEvent}
		</#if>
		
</#list>

</#macro>

<#macro ArgumentsList args>
	    <#list args as element>
	    <#assign link = element.getLinkToRefType()>
	    :param ${element.getAssociatedTypeName()} ${element.getName()}: <@IndentComment element.getComment() 5 />
	    <#if link?has_content>:type ${element.getName()}: :ref:`${element.getAssociatedTypeName()} <${link}>`</#if>
	    </#list>
</#macro>

<#macro EnumList Title elements isPreview=false addTitle=false>
<@SectionTitle Title addTitle/>
<#list elements as element>
<@Object element isPreview>
	<#assign enumItems = element.getEnumItems()>
	<#if enumItems?has_content><@ItemsList enumItems "Enum Items" isPreview /></#if>
</@Object>
</#list>
</#macro>

<#macro CovergroupList Title elements isPreview=false isVlogCovergroup=true addTitle=false>
<@SectionTitle Title addTitle/>
<#list elements as element>
<@Object element>
	<#if isVlogCovergroup><@VlogCovergroupItems element isPreview /><#else><@EdtCovergroupItems element isPreview/></#if>
</@Object>
</#list>
</#macro>

<#macro VlogCovergroupItems element isPreview=false>
<@ItemsList element.getCovergroupItems() "Coverpoints" isPreview/>
</#macro>

<#macro EdtCovergroupItems element isPreview=false>
<#assign coverItems = element.getCoverItems()>
<#assign coverCrosses = element.getCoverCrosses()>
<#assign coverTransitions = element.getCoverTransitions()>
<#if coverItems?has_content><@ItemsList coverItems "Coverage items" isPreview/></#if>
<#if coverCrosses?has_content><@ItemsList coverCrosses "Coverage crosses" isPreview/></#if>
<#if coverTransitions?has_content><@ItemsList coverTransitions "Coverage transitions" isPreview/></#if>
</#macro>


<#macro Object element isPreview=false>
.. container:: member
	:name: ${element.getID()}

	<#if hasCode>
	.. raw:: html
		
		<@ElementLinkToCode element />
	</#if>
	.. object:: ${element.getName()}
	    :no-index:
		
		<#if element.getComment()?has_content><@IndentComment element.getComment() 3/><#elseif isPreview>
			<@AiComment "element.getKind() ${element.getName()}" "${element.getDeclarationLine()}" 3/>
		</#if>
		
		<#nested>
</#macro>

<#macro ItemsList items title isPreview=false>
	    :${title}:
	    
	<#list items as item>	
		<#assign comment = item.getComment()>
		<#assign initialValue = item.getInitialValue()>
		- ${item.getName()}<#if initialValue?has_content> = ${initialValue}</#if>
		<#if comment?has_content><@IndentComment comment 5/><#elseif isPreview>
			<@AiComment "item.getKind() ${item.getName()}" "${item.getDeclarationLine()}" 3 />
		</#if>
	</#list>
</#macro>

<#macro ExpressionWithLinks listOfElementsAndLinks>
	<#list listOfElementsAndLinks>
		<#items as element>
			<#if element?is_odd_item>
				<#if listOfElementsAndLinks[element?index + 1]?has_content>
					:ref:`${element} <${listOfElementsAndLinks[element?index + 1]}>`
				<#else>
					${element}
				</#if>
			</#if>
		</#items>
	</#list>
</#macro>

<#macro GenericInitialValue generic>
	<#assign result>
		<@ExpressionWithLinks generic.getInitialValueWithUrls() />
	</#assign>
<@compress single_line = true>${result}</@compress>
</#macro>

<#macro GenericType generic>
	<#assign result>
		<#assign link = generic.getSimpleTypeUrl()>
		${(link?has_content)?then(':ref:`${generic.getSimpleTypeName()}<${link}>`', '${generic.getSimpleTypeName()}')}

		<#list generic.getTypeWithUrls()> 
			<#items as constraintValues>
				(<@ExpressionWithLinks constraintValues />)
			</#items>
		</#list>
	</#assign>
<@compress single_line = true>${result}</@compress>
</#macro>

<#macro TypeWithLinks element isPort=false>
	<#assign resultWithWhitespaces>
		<#if element.isTypeParameter()>
			type
		<#else>
			<#if !element.hasHyperlinks()>
				${element.getAssociatedTypeName()}
			<#else>
				<#if isPort>
				<#assign netType=element.getNetType()>
				<#if netType?has_content>${netType}</#if>
				</#if>
				
				<#assign link=element.getSimpleTypeLink()>
				${(link?has_content)?then(':ref:`${element.getType()} <${link}>`', '${element.getType()}')}
				
				<#assign typeWithUrls=element.getPackedTypeWithUrls()>
				<#if typeWithUrls?has_content> 
					<#list typeWithUrls as indexTypeValues>
						[<@ExpressionWithLinks indexTypeValues />]
					</#list>
				</#if>
				<#assign typeWithUrls=element.getUnpackedTypeWithUrls()>
				<#if typeWithUrls?has_content> 
					#
					<#list typeWithUrls as indexTypeValues>
						[<@ExpressionWithLinks indexTypeValues />]
					</#list>
				</#if>
			</#if>
		</#if>
	</#assign>
	<#assign result>
<@compress single_line = true>${resultWithWhitespaces}</@compress>
	</#assign>
${result?replace("[ ", "[")?replace(" ]", "]")?replace("# ", "#")}
</#macro>

<#macro ZoomButtons>
    .. raw:: html
	
        <div class="zoomBtns" style="margin: auto; text-align: center; position: absolute; right: 0; bottom: 0; top: 0;">
            <button id="zoom-in" style="display: block; margin: auto" title="Zoom in">
                <span class="fa fa-search-plus copy-icon"></span>
            </button>
            <button id="zoom-reset" style="display: block; margin-top: 2px; margin-bottom: 2px;" title="Reset">
                <span class="fa fa-refresh copy-icon"></span>
            </button>
            <button id="zoom-out" style="display: block; margin: auto" title="Zoom out">
                <span class="fa fa-search-minus copy-icon"></span>
            </button>
        </div>
	
</#macro>

<#macro ExpandButton id type caption indent=0>
${""?left_pad((indent > 1)?then(1, 0), "\t")}<#if (indent - 1 > 1)>    </#if>.. container:: diagram ${type}
${""?left_pad((indent > 1)?then(1, 0), "\t")}<#if (indent - 1 > 1)>    </#if>    :name: ${id}
	
${""?left_pad((indent > 1)?then(1, 0), "\t")}<#if (indent - 1 > 1)>    </#if>    .. raw:: html
	
${""?left_pad((indent > 1)?then(1, 0), "\t")}<#if (indent - 1 > 1)>    </#if>        <div class="hover-button">
${""?left_pad((indent > 1)?then(1, 0), "\t")}<#if (indent - 1 > 1)>    </#if>            <button title="Expand Diagram">
${""?left_pad((indent > 1)?then(1, 0), "\t")}<#if (indent - 1 > 1)>    </#if>                <span class="fa fa-arrows-alt expand-icon"></span>
${""?left_pad((indent > 1)?then(1, 0), "\t")}<#if (indent - 1 > 1)>    </#if>            </button>
${""?left_pad((indent > 1)?then(1, 0), "\t")}<#if (indent - 1 > 1)>    </#if>        </div>
		
    <#nested>
<#if caption?has_content>  
${""?left_pad((indent > 1)?then(1, 0), "\t")}<#if (indent - 1 > 1)>    </#if>    .. raw:: html
			
${""?left_pad((indent > 1)?then(1, 0), "\t")}<#if (indent - 1 > 1)>    </#if>        <figcaption>
${""?left_pad((indent > 1)?then(1, 0), "\t")}<#if (indent - 1 > 1)>    </#if>            <p><span class="caption-text" >${caption}</span><a class="headerlink" href="#${id}" title="Link to this image"></a></p>
${""?left_pad((indent > 1)?then(1, 0), "\t")}<#if (indent - 1 > 1)>    </#if>        </figcaption>
</#if>
</#macro>	

<#macro Diagram name caption="">
    .. raw:: html
  	    :file: diagrams/${name}
</#macro>

<#macro LinkToCode declaration line>
.. raw:: html

	<a class="viewcode-back" style="position: static;" href="code/${declaration}.html?${line}">[source]</a>
</#macro>

<#macro AiComment info start indent=1 insertAbove=false>
<#local spc>${""?left_pad(indent * 4)}</#local>
${spc}.. raw:: html
${spc}
${spc}	<div class="comment-for-ai" data-info="${info}" data-start="${start}" data-above=${insertAbove?c}>
${spc}		<a class="btn btn-neutral floating">
${spc}			<span class="fa"></span>
${spc}			<img src="">
${spc}	    </a>
${spc}	</div>
</#macro>

<#macro CopyButton id parameters ports caption>
.. container:: diagram block
    :name: ${id}
	
<#if !(isPreview?? && isPreview)>
    .. raw:: html
		
        <div class="hover-button" title="Copy Instance">
            <button>
                <span class="fa fa-clone copy-icon"></span>
            </button>
            <span class="copyText" style="display:none">
                ${unformatedname} <#list parameters>#(<#items as parameter>
                    .${parameter.getName()}(${parameter.getName()})<#sep>, </#sep></#items>
                    )</#list> 
                u_${unformatedname} <#list ports>(<#items as port>
                    .${port.getName()}(${port.getName()})<#sep>, </#sep></#items>
                    );</#list>
            </span>
        </div>
</#if>

<#nested>

    .. raw:: html
	
        <figcaption>
            <p><span class="caption-text">${caption}</span><a class="headerlink" href="#${id}" title="Link to this image"></a></p>
        </figcaption>

</#macro>


<#macro StructsList Title structs isPreview=false addTitle=false>
<@SectionTitle Title addTitle/>
<#list structs as struct>
<#assign comment=struct.getComment()>
.. container:: member
	:name: ${struct.getID()}

	<#if hasCode>
	.. raw:: html
		
		<@ElementLinkToCode struct />
	</#if>
	.. object:: ${struct.getDefinition()}
	    :no-index:
		
		<#if comment?has_content><@IndentComment comment 3/><#elseif isPreview>
			<@AiComment "struct ${struct.getName()} ${struct.getDefinition()}" "${struct.getDeclarationLine()}" 3/>
	  	</#if>
		<#if struct.hasBitField()><@BitFieldDiagram "${struct.getID()}-bitfield" struct.getName() struct.hasBitField() "VLOG_PACKED_STRUCT" struct.getBitFields()/></#if>
</#list>
</#macro>

<#macro BitFieldDiagram id name hasBitfieldDiagram kind bitfields>
<#if hasBitfieldDiagram>	  
.. container:: diagram bitfield
    :name: ${id}
	
	.. raw:: html
	  :file: diagrams/bitfield_${name}.svg

<@BitFieldTable kind bitfields/>
</#if>
</#macro>

<#macro BitFieldTable kind bitfields>
<#if kind == "VLOG_UVM_REG">
<@UVMRegBitFieldTable bitfields/>
</#if>

<#if kind == "VLOG_PACKED_STRUCT">
<@PackedStructBitFieldTable bitfields/>
</#if>
</#macro>

<#macro UVMRegBitFieldTable bitfields>
<#list bitfields>
.. list-table:: Bit Fields
    :widths: 20 8 10 9 11 10 12 10 10
    :header-rows: 1
    :class: longtable bitfield-table
    
    * - Field
      - Size
      - Position
      - Access
      - Volatility
      - Reset
      - Has Reset 
      - Randomized
      - Accessible
    <#items as bitfield>
    * - ${bitfield.getName()}		
      - ${bitfield.getBitfieldSize()}
      -	${bitfield.getBitfieldPosition()}
      - ${bitfield.getBitfieldAccess()}
      - ${bitfield.getBitfieldVolatile()}
      - ${bitfield.getBitfieldResetValue()}
      - ${bitfield.getBitfieldHasReset()}
      - ${bitfield.getBitfieldRandomized()}
      - ${bitfield.getBitfieldAccessible()}
    </#items>
</#list>
</#macro>

<#macro PackedStructBitFieldTable bitfields>
<#list bitfields>
.. list-table:: Bit Fields
    :widths: 25 25 25 25
    :header-rows: 1
    :class: longtable bitfield-table
    
    * - Name
      - Type
      - Position
      - Size

    <#items as bitfield>
    * - ${bitfield.getName()}		
      - ${bitfield.getBitfieldType()}
      -	${bitfield.getBitfieldPosition()}
      - ${bitfield.getBitfieldSize()}
    </#items>
</#list>
</#macro>

<#macro Instances key indent>
	<#list instances[key] as instance>	
	<#if instance.getID() != id && instances[instance.getID()]?? >
   ${"*"?left_pad(indent * 3 + 1, " ")} ${instance.getInstanceName()} <#if !instance.isBlock()> <@LinkToInstance instance/><#else> \: [${instance.getExpression()}]</#if>
	<@Instances instance.getID() indent + 1 />
	<#else>
   ${"*"?left_pad(indent * 3 + 1, " ")} ${instance.getInstanceName()} <@LinkToInstance instance/><#if instance.getInstanceParams()?has_content> ${instance.getInstanceParams()}</#if>
	</#if>
	</#list>
</#macro>

<#macro SubInstances submodules>
<#list submodules["instance"] as instance>
* ${instance.getName()}<#if instance.getLanguageKind() == "VHDL"> of <@LinkToEntity instance/></#if><#if instance.getInstanceParams()?has_content> ${instance.getInstanceParams()}</#if>
<#list submodules["${instance.getName()}${instance.getInstanceParams()}"] as submodule>
   * ${submodule.getInstanceName()} <#if !submodule.isBlock()><@LinkToInstance submodule/><#else> \: [${submodule.getExpression()}]</#if><#if submodule.getInstanceParams()?has_content> ${submodule.getInstanceParams()}</#if>
</#list>
</#list>
</#macro>

<#macro LinkToInstance instance> <#if instance.getLanguageKind() == "VHDL"><@LinkToInstanceVHDL instance /><#else><@LinkToInstanceVLOG instance /></#if></#macro>

<#macro LinkToInstanceVLOG instance> \: :ref:`${instance.getName()}<${instance.getID()}>`</#macro>

<#macro LinkToInstanceVHDL instance>\: <#if instance.isComponent()><@LinkToComponent instance /><#else><@LinkToComponent instance/> of <@LinkToEntity instance/></#if></#macro>

<#macro LinkToComponent instance><#if instance.hasHyperlink()>:ref:`${instance.getName()}<${instance.getID()}>`<#else>${instance.getName()}</#if></#macro>

<#macro LinkToEntity instance><#if instance.hasHyperlink()>:ref:`${instance.getEntityName()}<${instance.getEntityID()}>`<#else>${instance.getEntityName()}</#if></#macro>

<#macro SectionTitle title addTitle=false>
${title}
${""?left_pad(title?length, addTitle?then("-", "="))}
</#macro>

<#macro AssertionsTable title assertions isPreview=false forAggregatedPage=false>
<#list assertions>
.. list-table:: ${title}
    :widths: 24 24 52
    :header-rows: 1
    :class: longtable assertions

    
    * - Name
      - Kind
      - Description
    <#items as assertElement>
    <#assign comment=assertElement.getComment()>
    <#assign kind=assertElement.getAssertionKind(forAggregatedPage)>
    <#assign assertName=assertElement.getCompleteAssertionName()>
    <#assign expr=assertElement.getAssertionExpression()>
    <#assign link=assertElement.getLinkToRef()>

    * - <#if link?has_content && forAggregatedPage > :ref:`${assertName} <${link}>` <#else> ${assertName} </#if>
      - ${kind}
      - <#if comment?has_content><@IndentComment comment 3/><#elseif isPreview>

			<@AiComment "assert ${assertName} ${kind} ${expr}" "${assertElement.getCommentLine()}" 3 true/>
			
        </#if>
        
        .. code-block:: systemverilog 
      
			${expr}
    </#items>
</#list>
</#macro>
