<#macro Align text indent>${text?replace('\n', '\n'?right_pad(indent + 1, '\t'))}</#macro>

<#macro IndentComment commentSegments indent>
<#list commentSegments as commentSegment>

<#switch commentSegment.getType()>
	<#case "title">
		<#break>
	<#case "text">
${""?left_pad((indent > 1)?then((indent > 3)?then(2, 1), 0), "\t")}<#if (indent > 1)>    </#if>.. raw:: latex

${""?left_pad(indent, "\t")}\begin{markdown}
${""?left_pad(indent, "\t")} <@Align commentSegment.getContent() indent />
${""?left_pad(indent, "\t")}\end{markdown}
		<#break>
	<#case "custom_diagram">
	<#case "wavedrom">
${""?left_pad((indent > 1)?then((indent > 3)?then(2, 1), 0), "\t")}<#if (indent > 1)>    </#if>.. image:: ${commentSegment.getContent()}
${""?left_pad((indent > 1)?then((indent > 3)?then(2, 1), 0), "\t")}<#if (indent > 1)>    </#if>    :align: center
${""?left_pad((indent > 1)?then((indent > 3)?then(2, 1), 0), "\t")}<#if (indent > 1)>    </#if>    :scale: 100%
		<#break>
	<#case "code-block">
${""?left_pad((indent > 1)?then((indent > 3)?then(2, 1), 0), "\t")}<#if (indent > 1)>    </#if>.. code-block::
	
${""?left_pad(indent, "\t")}<@Align commentSegment.getContent() indent/>
		<#break>
	<#case "none">
${""?left_pad((indent > 1)?then((indent > 3)?then(2, 1), 0), "\t")}<#if (indent - 1 > 1)>    </#if>.. highlight:: none

${""?left_pad((indent > 1)?then((indent > 3)?then(2, 1), 0), "\t")}<#if (indent - 1 > 1)>    </#if>::
	
${""?left_pad(indent, "\t")}<@Align commentSegment.getContent() indent/>
		<#break>	
	<#case "rst">
<#assign rstIndent>${'\n'?right_pad((indent > 1)?then((indent > 3)?then(3, 2), 1), "\t")}<#if (indent - 1 > 1)>    </#if></#assign>
${rstIndent}${commentSegment.getContent()?replace('\n', rstIndent)}
</#switch>
</#list>
</#macro>

<#macro Comment comment>
	<#assign commentTitle = "">
	<#if comment[0]?? && comment[0].getType() == "title">
		<#assign commentTitle = comment[0].getContent()>
	</#if>
.. admonition:: <#if commentTitle?has_content>${commentTitle}<#else>\ \</#if>
	
	<@IndentComment comment 2 />
</#macro>

<#macro TableComment commentSegments>
<#list commentSegments as commentSegment>${commentSegment.getContent()?replace('\n|\t', ' ', 'r')?trim?replace("`", "")} </#list>
</#macro>

<#macro ElementHeader name id qualifiers="" returnType="">
		\phantomsection\label{${id}}
		\item \begin{description}
		\item ${qualifiers} ${returnType} ${name} <#nested>
		\end{description}
</#macro>

<#macro TableCellName element>
${element.getFormatedName()}

	    .. raw:: latex
        
	    	\label{${element.getID()}}
</#macro>

<#macro Object element isPreview=false>
.. _${element.getID()}:
.. container:: member

	.. raw:: latex
	
		\phantomsection\label{${element.getID()}}
	.. object:: ${element.getName()}
	    :no-index:
		
		<@IndentComment element.getComment() 3/>	
		
		<#nested>
</#macro>

<#macro FunctionsList Title elements isPreview=false hasParent=false addSubtitle=false>
<@SectionTitle Title addSubtitle/>
<#list elements as element>
.. _${element.getID()}:
.. container:: member

	.. raw:: latex
	
		\phantomsection\label{${element.getID()}}
	
	<#assign argumentsList = element.getFunctionArgumentsList()>
	<#assign arguments><@FunctionArguments argumentsList /></#assign>
	.. function:: ${element.getQualifiers()} function ${element.getReturnTypeName()} ${element.getName()}${arguments?trim}
	    :no-index:
		
		<@IndentComment element.getComment() 3/>
		
	    <@ArgumentsList argumentsList/>
	    <#assign returnTypeLink = element.getLinkToReturnType()>
	    <#if returnTypeLink?has_content>:rtype: :ref:`${element.getReturnTypeName()} <${returnTypeLink}>`</#if>	
	    
	   	<#if hasParent>
		<#assign packageLink><#if element.getParentPackageName()?has_content>:ref:`${element.getParentPackageName()}<${element.getLinkToPackage()}>`<#else>${element.getParentPackageName()}</#if> :: </#assign>
		<#assign parentStructLink><#if element.getLinkToParent()?has_content>:ref:`${element.getParentName()}<${element.getLinkToParent()}>`<#else>${element.getParentName()}</#if> . </#assign>
		<#assign parentMethod><#if element.getLinkToParentMethod()?has_content>:ref:`${element.getName()}<${element.getLinkToParentMethod()}>`<#else>${element.getName()}</#if></#assign>
	    :Parent: ${packageLink}${parentStructLink}${parentMethod}
		</#if>
		
</#list>
</#macro>

<#macro FunctionArguments agumentsList>
<#assign result="">
<#list agumentsList as argument>
	<#assign result = "${result}${argument.getAssociatedTypeName()} ${argument.getName()}">
	<#assign initialValue = argument.getInitialValue()>
	<#if initialValue?has_content><#assign result="${result} = ${initialValue}"></#if>
	<#assign result>${result}<#sep>, </#sep></#assign>
</#list>
(${result})
</#macro>

<#macro MemberList Title elements isPreview=false addSubtitle=false>
<@SectionTitle Title addSubtitle/>
<#list elements as element>
<@Object element />
</#list>
</#macro>

<#macro AlwaysBlock alwaysBlock index isPreview=false isProcess=false>
.. _${alwaysBlock.getKind()}-${index}:
.. container:: member
	
	.. raw:: latex
	
		\phantomsection\label{${alwaysBlock.getKind()}-${index}}
	
	.. function:: <#if !isProcess>${alwaysBlock.getName()}</#if>${alwaysBlock.getType()}@(${alwaysBlock.getSensitivityList()})
	    :no-index:
		
		<@IndentComment alwaysBlock.getComment() 3/>
		
</#macro>

<#macro Modport Title elements>
<@SectionTitle Title />
<#list elements as element>
.. _${element.getID()}:
.. container:: member
	
	.. raw:: latex
	
		\phantomsection\label{${element.getID()}}
	
	<#assign portsList = element.getPortsList()>
	<#assign ports><@ModportArguments portsList /></#assign>
	.. function:: ${element.getName()}${ports?trim}
	    :no-index:
		
		<@IndentComment element.getComment() 3/>
		
		<@PortsList portsList />
</#list>
</#macro>

<#macro ModportArguments portsList>
<#assign result="">
<#list portsList as port>
	<#assign result = "${result}${port.getAssociatedTypeName()} ${port.getName()}">
	<#assign result>${result}<#sep>, </#sep></#assign>
</#list>
(${result})
</#macro>

<#macro PortsList ports>
	(<#list ports><#items as element>${element.getDirection()} ${element.getAssociatedTypeName()} ${element.getFormatedName()}<#sep>, </#sep></#items> </#list>)
</#macro>

<#macro SamplingEvent element>
		<#assign eventUrl = element.getSamplingEventUrl()>
		<#if eventUrl?has_content>{\hyperref[\detokenize{${eventUrl}}]{\sphinxcrossref{\DUrole{std,std-ref}{${element.getSamplingEvent()}}}}}<#else> ${element.getSamplingEvent()} </#if>
</#macro>

<#macro ReturnType element>
		<#assign returnTypeLink = element.getLinkToReturnType()> 
		: <#if returnTypeLink?has_content>{\hyperref[\detokenize{${returnTypeLink}}]{\sphinxcrossref{\DUrole{std,std-ref}{${element.getReturnTypeName()}}}}} <#else> ${element.getReturnTypeName()} </#if>
</#macro>

<#macro MethodList Title elements isPreview=false>

<@SectionTitle Title />
<#list elements as element>
.. _${element.getID()}:
.. container:: member
	
	.. raw:: latex
	
		\phantomsection\label{${element.getID()}}
	
	<#assign argumentsList = element.getFunctionArgumentsList()>
	<#assign arguments><@FunctionArguments argumentsList /></#assign>
	.. function:: ${element.getName()}${arguments?trim}${element.getSamplingEvent()} : ${element.getReturnTypeName()}
	    :no-index:
		
		<@IndentComment element.getComment() 3/>
		
	    <@ArgumentsList argumentsList/>
	    <#assign returnTypeLink = element.getLinkToReturnType()>
	    <#if returnTypeLink?has_content>:rtype: :ref:`${element.getReturnTypeName()} <${returnTypeLink}>`</#if>	
	    
	    <#assign eventUrl = element.getSamplingEventUrl()>
	    <#if eventUrl?has_content>:Sampling Event: :ref:`${element.getSamplingEvent()}<${eventUrl}>`</#if>
	    
	    <#if element.hasParent()>
		<#assign packageLink><#if element.getParentPackageName()?has_content>:ref:`${element.getParentPackageName()}<${element.getLinkToPackage()}>`<#else>${element.getParentPackageName()}</#if> :: </#assign>
		<#assign parentStructLink><#if element.getLinkToParent()?has_content>:ref:`${element.getParentName()}<${element.getLinkToParent()}>`<#else>${element.getParentName()}</#if> . </#assign>
		<#assign parentMethod><#if element.getLinkToParentMethod()?has_content>:ref:`${element.getName()}<${element.getLinkToParentMethod()}>`<#else>${element.getName()}</#if></#assign>
	    :Parent: ${packageLink}${parentStructLink}${parentMethod}
		</#if>
</#list>
</#macro>

<#macro ExtendedMembers Title elements isPreview=false>

<@SectionTitle Title />
<#list elements as element>
	
<@Object element />

		<#if element.hasParent()>
		<#assign packageLink><#if element.getParentPackageName()?has_content>:ref:`${element.getParentPackageName()}<${element.getLinkToPackage()}>`<#else>${element.getParentPackageName()}</#if> :: </#assign>
		<#assign parentStructLink><#if element.getLinkToParent()?has_content>:ref:`${element.getParentName()}<${element.getLinkToParent()}>`<#else>${element.getParentName()}</#if> . </#assign>
		<#assign parentEvent><#if element.getLinkToParentEvent()?has_content>:ref:`${element.getName()}<${element.getLinkToParentEvent()}>`<#else>${element.getName()}</#if></#assign>
	    :Parent: ${packageLink}${parentStructLink}${parentEvent}
		</#if>
</#list>

</#macro>

<#macro ArgumentsList args>
	    <#list args as element>
	    <#assign link = element.getLinkToRefType()>
	    :param ${element.getAssociatedTypeName()} ${element.getName()}: <@IndentComment element.getComment() 5 />
	    :type ${element.getName()}: <#if link?has_content>:ref:`${element.getAssociatedTypeName()} <${link}>`<#else>${element.getAssociatedTypeName()}</#if>
	    </#list>
</#macro>

<#macro EnumList Title elements isPreview=false addSubtitle=false>
<@SectionTitle Title addSubtitle/>
<#list elements as element>
<@Object element>
	<#assign enumItems = element.getEnumItems()>
	<#if enumItems?has_content><@ItemsList enumItems "Enum Items" /></#if>
</@Object>
</#list>
</#macro>


<#macro CovergroupList Title elements isPreview=false isVlogCovergroup=true addSubtitle=false>
<@SectionTitle Title addSubtitle/>
<#list elements as element>
<@Object element>
	<#if isVlogCovergroup><@VlogCovergroupItems element /><#else><@EdtCovergroupItems element /></#if>
</@Object>	
</#list>
</#macro>

<#macro VlogCovergroupItems element>
<#assign coverItems = element.getCovergroupItems()>
<#if coverItems?has_content>
<@ItemsList coverItems "Coverpoints" />
</#if>
</#macro>

<#macro EdtCovergroupItems element>
<#assign coverItems = element.getCoverItems()>
<#assign coverCrosses = element.getCoverCrosses()>
<#assign coverTransitions = element.getCoverTransitions()>
<#if coverItems?has_content><@ItemsList coverItems "Coverage items" /></#if>
<#if coverCrosses?has_content><@ItemsList coverCrosses "Coverage crosses" /></#if>
<#if coverTransitions?has_content><@ItemsList coverTransitions "Coverage transitions" /></#if>
</#macro>

<#macro ItemsList items title isPreview=false>
	    :${title}:
	    
	<#list items as item>	
		<#assign comment = item.getComment()>
		<#assign initialValue = item.getInitialValue()>
		- ${item.getName()}<#if initialValue?has_content> = ${initialValue}</#if>
		<@IndentComment comment 5/>
		
	</#list>
</#macro>

<#macro ExpressionWithLinks listOfElementsAndLinks>
	<#list listOfElementsAndLinks>
		<#items as element>
			<#if element?is_odd_item>
				<#if listOfElementsAndLinks[element?index + 1]?has_content>
					:ref:`${element} <${listOfElementsAndLinks[element?index + 1]}>`
				<#else>
					${element}
				</#if>
			</#if>
		</#items>
	</#list>
</#macro>

<#macro GenericInitialValue generic>
	<#assign values = generic.getInitialValueWithUrls()>
	<#assign result>
		<@ExpressionWithLinks generic.getInitialValueWithUrls() />
	</#assign>
<@compress single_line = true>${result}</@compress>
</#macro>

<#macro GenericType generic>
	<#assign result>
		<#assign link = generic.getSimpleTypeUrl()>
		${(link?has_content)?then(':ref:`${generic.getSimpleTypeName()}<${link}>`', '${generic.getSimpleTypeName()}')}

		<#assign constraints = generic.getTypeWithUrls()>
		<#list constraints> 
			<#items as constraintValues>
				(<@ExpressionWithLinks constraintValues />)
			</#items>
		</#list>
	</#assign>
<@compress single_line = true>${result}</@compress>
</#macro>

<#macro TypeWithLinks element isPort=false>
	<#assign resultWithWhitespaces>
		<#if !element.hasHyperlinks()>
			${element.getAssociatedTypeName()}
		<#else>
			<#if isPort>
				<#assign netType=element.getNetType()>
				<#if netType?has_content>${netType}</#if>
			</#if>
			
			<#assign link=element.getSimpleTypeLink()>
			${(link?has_content)?then(':ref:`${element.getType()} <${link}>`', '${element.getType()}')}
			
			<#assign typeWithUrls=element.getPackedTypeWithUrls()>
			<#if typeWithUrls?has_content> 
				<#list typeWithUrls as indexTypeValues>
					[<@ExpressionWithLinks indexTypeValues />]
				</#list>
			</#if>
			<#assign typeWithUrls=element.getUnpackedTypeWithUrls()>
			<#if typeWithUrls?has_content> 
				#
				<#list typeWithUrls as indexTypeValues>
					[<@ExpressionWithLinks indexTypeValues />]
				</#list>
			</#if>
		</#if>
	</#assign>
	<#assign result>
<@compress single_line = true>${resultWithWhitespaces}</@compress>
	</#assign>
${result?replace("[ ", "[")?replace(" ]", "]")?replace("# ", "#")}
</#macro>

<#macro ExpandButton id type caption="">
.. _${id}:
.. container:: diagram ${type}
	
<#nested>	
</#macro>

<#macro CopyButton name parameters ports caption="" >
.. container:: diagram block

<#nested>	
</#macro>

<#macro Diagram name caption="">
	.. figure:: diagrams/${name}
		:align: center
		:scale: 75%
		
		${caption}
</#macro>

<#macro StructsList Title elements isPreview=false addSubtitle=false>
<@SectionTitle Title addSubtitle/>
<#list structs as struct>
.. _${struct.getID()}:
.. container:: member

	.. raw:: latex
	
		\phantomsection\label{${struct.getID()}}

	.. object:: ${struct.getDefinition()}
	    :no-index:
		
		<@IndentComment struct.getComment() 3/>	
		
		<#if struct.hasBitField()><@BitFieldDiagram "${struct.getID()}-bitfield" struct.getName() struct.hasBitField() "VLOG_PACKED_STRUCT" struct.getBitFields()/></#if>
</#list>
</#macro>

<#macro BitFieldDiagram id name hasBitfieldDiagram kind bitfields>
<#if hasBitfieldDiagram>
.. image:: diagrams/bitfield_${name}.svg
	:align: center
	:scale: 100%


<@BitFieldTable kind bitfields/>
</#if>
</#macro>

<#macro BitFieldTable kind bitfields>
<#if kind == "VLOG_UVM_REG">
<@UVMRegBitFieldTable bitfields/>
</#if>

<#if kind == "VLOG_PACKED_STRUCT">
<@PackedStructBitFieldTable bitfields/>
</#if>
</#macro>

<#macro UVMRegBitFieldTable bitfields>
<#list bitfields>
.. list-table:: Bit Fields
    :widths: 20 8 10 9 11 10 12 10 10
    :header-rows: 1
    :class: longtable
    
    * - Field
      - Size
      - Position
      - Access
      - Volatility
      - Reset
      - Has Reset 
      - Randomized
      - Accessible
    <#items as bitfield>
    * - ${bitfield.getName()}		
      - ${bitfield.getBitfieldSize()}
      -	${bitfield.getBitfieldPosition()}
      - ${bitfield.getBitfieldAccess()}
      - ${bitfield.getBitfieldVolatile()}
      - ${bitfield.getBitfieldResetValue()}
      - ${bitfield.getBitfieldHasReset()}
      - ${bitfield.getBitfieldRandomized()}
      - ${bitfield.getBitfieldAccessible()}
    </#items>
</#list>
</#macro>

<#macro PackedStructBitFieldTable bitfields>
<#list bitfields>
.. list-table:: Bit Fields
    :widths: 25 25 25 25
    :header-rows: 1
    :class: longtable
    
    * - Name
      - Type
      - Position
      - Size

    <#items as bitfield>
    * - ${bitfield.getName()}		
      - ${bitfield.getBitfieldType()}
      -	${bitfield.getBitfieldPosition()}
      - ${bitfield.getBitfieldSize()}
    </#items>
</#list>
</#macro>

<#macro ZoomButtons>
</#macro>

<#macro Instances key indent>
	<#list instances[key] as instance>	
	<#if instance.getID() != id && instances[instance.getID()]?? >
   ${"*"?left_pad(indent * 3 + 1, " ")} ${instance.getInstanceName()} <#if !instance.isBlock()> <@LinkToInstance instance /><#else> \: [${instance.getExpression()}]</#if>
	<@Instances instance.getID() indent + 1 />
	<#else>
   ${"*"?left_pad(indent * 3 + 1, " ")} ${instance.getInstanceName()} <@LinkToInstance instance /><#if instance.getInstanceParams()?has_content> ${instance.getInstanceParams()}</#if>
	</#if>
	</#list>
</#macro>

<#macro SubInstances submodules>
<#list submodules["instance"] as instance>
* ${instance.getName()}<#if instance.getLanguageKind() == "VHDL"> of <@LinkToEntity instance/></#if><#if instance.getInstanceParams()?has_content> ${instance.getInstanceParams()}</#if>
<#list submodules["${instance.getName()}${instance.getInstanceParams()}"] as submodule>
   * ${submodule.getInstanceName()} <#if !submodule.isBlock()><@LinkToInstance submodule/><#else> \: [${submodule.getExpression()}]</#if><#if submodule.getInstanceParams()?has_content> ${submodule.getInstanceParams()}</#if>
</#list>
</#list>
</#macro>

<#macro LinkToInstance instance> <#if instance.getLanguageKind() == "VHDL"><@LinkToInstanceVHDL instance /><#else><@LinkToInstanceVLOG instance /></#if></#macro>

<#macro LinkToInstanceVLOG instance> \: :ref:`${instance.getName()}<${instance.getID()}>`</#macro>

<#macro LinkToInstanceVHDL instance>\: <#if instance.isComponent()><@LinkToComponent instance /><#else><@LinkToComponent instance/> of <@LinkToEntity instance/></#if></#macro>

<#macro LinkToComponent instance><#if instance.hasHyperlink()>:ref:`${instance.getName()}<${instance.getID()}>`<#else>${instance.getName()}</#if></#macro>

<#macro LinkToEntity instance><#if instance.hasHyperlink()>:ref:`${instance.getEntityName()}<${instance.getEntityID()}>`<#else>${instance.getEntityName()}</#if></#macro>

<#macro SectionTitle title addSubtitle=false>
<#if addSubtitle>
${title}
${""?left_pad(title?length, "-")}
<#else>
.. rubric:: ${title}
</#if>
</#macro>

<#macro AssertionsTable title assertions isPreview=false forAggregatedPage=false>
<#list assertions>
.. list-table:: ${title}
    :widths: 24 24 52
    :header-rows: 1
    :class: longtable assertions

    
    * - Name
      - Kind
      - Description
    <#items as assertElement>
    <#assign comment=assertElement.getComment()>
    <#assign kind=assertElement.getAssertionKind(forAggregatedPage)>
    <#assign assertName=assertElement.getCompleteAssertionName()>
    <#assign expr=assertElement.getAssertionExpression()>
    <#assign link=assertElement.getLinkToRef()>

    * - <#if link?has_content && forAggregatedPage > :ref:`${assertName} <${link}>` <#else> ${assertName} </#if>
      - ${kind}
      - <#if comment?has_content><@IndentComment comment 3/></#if>
        
        .. code-block:: systemverilog 
      
			${expr}
    </#items>
</#list>
</#macro>
