header {
    package ro.amiq.dvt.utils.expr; 
        
    import java.io.File;
    import java.io.CharArrayReader;
    import java.io.FileInputStream;
    import java.io.BufferedInputStream;
    import java.io.InputStream;
    import java.io.IOException;
    import java.io.BufferedReader;
    
    import antlr.Token;
    import ro.amiq.dvt.startup.core.DVTLogger;
    import ro.amiq.dvt.utils.DVTStringUtil;
    import ro.amiq.dvt.utils.DVTUtilsCommon;
}
   
class ExprLexer extends Lexer; 

options {
    k = 3;
    exportVocab=ExprLexer;
}

{
    protected ExprLexerStack stack;
    protected ExprUtil util;
    protected Reader reader;

	public ExprLexer(Reader in, boolean dummy) {
		this(new CharBuffer(in));
		reader = in;
	}
	
    public final void uponEOF() throws TokenStreamException, CharStreamException {
		DVTUtilsCommon.INSTANCE.closeClosable(reader);
        if (stack != null)
        	stack.pop();
    }
    
    @Override
    public void userExceptionHandler(Exception ex) throws RecognitionException, CharStreamException, TokenStreamException {
        if (ex instanceof RecognitionException)
            throw (RecognitionException) ex;
        if (ex instanceof CharStreamException)
            throw (CharStreamException) ex;
        if (ex instanceof TokenStreamException)
            throw (TokenStreamException) ex;
        DVTLogger.INSTANCE.logError(ex);
    }

    @Override
	public void reportError(RecognitionException ex) {
    	util.setError(ex);
	}

}
    
protected
VOCAB
    :
      '\3'..'\377'
    ;

WS    
    :
      ( ' '
      | '\t'
      | '\f'
      )+
      {
          $setType(Token.SKIP); 
      }
    ;

COLON                   options {paraphrase = ":";   }: ":";
STAR                    options {paraphrase = "*";   }: "*";
DIV                     options {paraphrase = "/";   }: "/";
MOD                     options {paraphrase = "%";   }: "%";
PLUS                    options {paraphrase = "+";   }: "+";
PLUS_PLUS               options {paraphrase = "++";  }: "++";
MINUS                   options {paraphrase = "-";   }: "-";
MINUS_MINUS             options {paraphrase = "--";  }: "--";
SR                      options {paraphrase = ">>";  }: ">>";
SL                      options {paraphrase = "<<";  }: "<<";
BAND                    options {paraphrase = "&";   }: "&";
BOR                     options {paraphrase = "|";   }: "|";
BXOR                    options {paraphrase = "^";   }: "^";
BNOT                    options {paraphrase = "~";   }: "~";
LNOT                    options {paraphrase = "!";   }: "!";
LAND                    options {paraphrase = "&&";  }: "&&";
LOR                     options {paraphrase = "||";  }: "||";
EQUAL                   options {paraphrase = "==";  }: "==";
NOT_EQUAL               options {paraphrase = "!=";  }: "!=";
LT                      options {paraphrase = "<";   }: "<";
GT                      options {paraphrase = ">";   }: ">";
LE                      options {paraphrase = "<=";  }: "<=";
GE                      options {paraphrase = ">=";  }: ">=";
LPAREN                  options {paraphrase = "(";   }: "(";
RPAREN                  options {paraphrase = ")";   }: ")";
QUESTION                options {paraphrase = "?";   }: "?";

ID 
{
	Token id = null;
}
    : 
      ( "defined" ( WS )? ( LPAREN | INTERNAL_ID ) ) => "defined" ( WS )? ( LPAREN ( WS )? id1:INTERNAL_ID { id = id1; } ( WS )? RPAREN | id2:INTERNAL_ID { id = id2; } ) 
    {
      	if (id != null) {
      		String defined = util.isDefined(id.getText());
      		$setText(defined);
      		$setType(NUMBER);
        } else {
        	$setText("0");
            $setType(NUMBER); 
      	}
    } 
    | id3:INTERNAL_ID { id = id3; }
    {
    	if (id != null) {
	    	String replacement = util.getValue(id.getText());
	        if (replacement != null) {
		    	boolean isNumber = DVTStringUtil.isNumber(replacement);
		    	if (isNumber) {
		        	$setText(replacement);
		            $setType(NUMBER); 
		    	} else {
		            char[] charvals = replacement.toString().toCharArray();
		            Reader charir = new CharArrayReader(charvals);
		            ExprLexer newLexer = new ExprLexer(new BufferedReader(charir), false);
		
		            newLexer.stack = stack;
		            newLexer.util = util;
		            newLexer.setFilename(getFilename());
		            stack.push(newLexer);
		            $setType(Token.SKIP);
		    	}
	        } else {
	        	$setText("0");
	            $setType(NUMBER); 
	        }
        } else {
        	$setText("0");
            $setType(NUMBER); 
    	}
    }
    ;
    
protected 
INTERNAL_ID
	:
      ( 'a'..'z' | 'A'..'Z' | '_' ) ( options { greedy = true; } : 'a'..'z' | 'A'..'Z' | '0'..'9' | '_' )*
    ;

NUMBER
    :    
      ( '0'..'9' )+ 
    ;


    
    
    