header {
    package ro.amiq.dvt.utils.expr;
    import antlr.RecognitionException;
    import antlr.Token;
import ro.amiq.dvt.startup.core.DVTLogger;
import ro.amiq.dvt.utils.DVTStringUtil;
}

class ExprParser extends Parser;

options {
    importVocab=ExprLexer;
    buildAST = false;
    k = 2;
}

{
    protected ExprUtil util;

	@Override
	public void reportError(RecognitionException ex) {
		util.setError(ex);
	}
	
	public void userExceptionHandler(Exception ex) {
    	// default implementation throws the exception
//		DVTLogger.INSTANCE.logError(ex);
		ex.printStackTrace();
//    	throw ex;
    }
}

primary returns [int result = 0]
	:
		LPAREN result = expression RPAREN
	|	n1:NUMBER { result = DVTStringUtil.parseInt(n1.getText(), 0); }
	| 	( PLUS | m:MINUS ) n2:NUMBER { result = DVTStringUtil.parseInt(n2.getText(), 0); result = m == null ? result : -result; }
	;

expression_primary returns [int result = 0]
{
	int temp = 1;
	int opi = 0;
}		
    :
        LNOT temp = expression { result = temp != 0 ? 0 : 1; }
    |   opi = inc_or_dec temp = expression { result = opi > 0 ? ++temp : --temp; }
    |   temp = primary ( ( inc_or_dec ) => opi = inc_or_dec { result = opi > 0 ? ++temp : --temp; } | /*nothing*/  { result = temp; } )
    // FIXME add other unary operators (i.e. reduction operators)
    ;

inc_or_dec returns [int result = 0]
	:
		PLUS_PLUS { result = 1; } | MINUS_MINUS { result = -1; }
    ;
    
expression_double_star returns [int result = 0]
{
	int temp = 1;
}
    :
    	result = expression_primary ( DOUBLE_STAR temp = expression_double_star { result = (int) Math.pow(result, temp); } )?
    ;

expression_mul_div returns [int result = 0]
{
	int temp = 1;
	int op = 0;
}
    :
    	result = expression_double_star ( ( STAR | DIV { op = 1; } | MOD { op = 2; } ) temp = expression_mul_div { result = (op == 0)? result * temp : (op == 1)? result / temp : result % temp; } )?
    ;

expression_plus_minus returns [int result = 0]
{
	int temp = 1;
	int op = 0;
}
    :
    	result = expression_mul_div ( ( PLUS | MINUS { op = 1; } ) temp = expression_plus_minus { result = (op == 0)? result + temp : result - temp; } )?
    ;

expression_shift returns [int result = 0]
{
	int temp = 1;
	int op = 0;
}
    :
    	result = expression_plus_minus ( ( SL | SR { op = 1; } ) temp = expression_shift { result = (int) ((op == 0)? result * Math.pow(2, temp) : result / Math.pow(2, temp)); } )?
    ;

expression_prec returns [int result = 0]
{
	int temp = 1;
	int op = 0;
}
    :
    	result = expression_shift ( ( LT | LE { op = 1; } | GT { op = 2; } | GE { op = 3; } ) temp = expression_prec { boolean isTrue = (op == 0)? result < temp : (op == 1)? result <= temp : (op == 2)? result > temp : result >= temp; result = (isTrue)? 1 : 0; } )?
    ;

expression_equal returns [int result = 0]
{
	int temp = 1;
	int op = 0;
}
    :
    	result = expression_prec ( ( EQUAL | NOT_EQUAL { op = 1; } ) temp = expression_equal { result = (result == temp)? 1 - op : op; } )?
    ;

expression_band returns [int result = 0]
{
	int temp = 1;
	int op = 0;
}
    :
    	result = expression_equal ( BAND temp = expression_band { result = result & temp; } )?
    ;

expression_bxor returns [int result = 0]
{
	int temp = 1;
	int op = 0;
}
    :
    	result = expression_band ( ( BXOR | BXNOR { op = 1; } ) temp = expression_bxor { result = (op == 0)? result ^ temp : result ^~ temp; } )?
    ;

expression_bor returns [int result = 0]
{
	int temp = 1;
}
    :
    	result = expression_bxor ( BOR temp = expression_bor { result = result | temp; } )?
    ;

expression_land returns [int result = 0]
{
	int temp = 1;
}
    :
    	result = expression_bor ( LAND temp = expression_land { result = result & temp; } )?
    ;

expression_lor returns [int result = 0]
{
	int temp = 1;
}
    :
    	result = expression_land ( LOR temp = expression_lor { result = result | temp; } )?
    ;

expression_cond[int val] returns [int result = 0]
{
	int temp = 1;
}
    :
    	result = expression COLON temp = expression { result = val <= 0 ? result : temp; }
    ;

expression returns [int result = 0]
	:
		result = expression_lor ( QUESTION result = expression_cond[result] )?
	;

evaluate returns [int result = 0]
	:
		result = expression EOF
	;


