
<#--//    Paste as entity instance   //-->

<#macro portInstance port >
	<#assign portName = r"${" + port.getName() + "}">
	${port.getName()} => ${portName}<#t>
</#macro>

<#macro variableInstance variable >
	<#assign variableName = r"${" + variable.getName() + "}">
	${variable.getName()} => <#if variable.hasInitialValue() >${variable.getInitialValue()}<#else>${variableName}</#if><#t>
</#macro>	

<#macro pasteAsInstance entity >
<#assign libraryVar = r"${"+ "work" + "}">
${common.instanceName(entity.getName(), "u_")} : ENTITY ${libraryVar}.${entity.getName()}<#t>
<#if !entity.hasGenerics()&&!entity.hasPorts() >;</#if>
<#if entity.hasGenerics() >
	GENERIC MAP ( <#lt>
	<#list entity.getGenerics() as variable>
	<@variableInstance variable/><#if variable_has_next >,</#if>
	</#list>
	<#if entity.hasPorts()>
	)<#lt>
	<#else>
	);<#lt>
	</#if>  
</#if>
<#if entity.hasPorts()> 
	PORT MAP ( <#lt>
	<#list entity.getPorts() as port>
	<@portInstance port /><#if port_has_next >,</#if>
	</#list>
	); <#lt>
</#if>
${common.cursorPosition} <#rt>
</#macro>

<#function portRange port>
	<#if port.hasRangeConstraint()>
		<#return " " + port.getRange()>
	<#else>
	<#if port.hasRange()>
	    <#return "(" + port.getRange() + ")">
	</#if>
	</#if>
	<#return "">
</#function>

<#function genericRange generic>
	<#return portRange(generic)>
</#function>

<#--//    Paste as signal declarations    //-->

<#macro signalDeclaration port >
<#assign signalName = r"${" + port.getName() + "}" >
<#assign signalType = port.getType()!"std_logic" >
SIGNAL ${signalName} : ${signalType}${portRange(port)};
</#macro>

<#macro pasteAsSignals entity >
	<#list entity.getPorts() as port>
	<@signalDeclaration port/><#lt>
	</#list>
</#macro>

<#--//     Paste as testbench       //-->

<#function showInitialValueGeneric generic>
	<#if (generic.hasInitialValue())>
		<#return " := " + generic.getInitialValue()>
	</#if>
	<#return "">
</#function>

<#macro listGenerics entity>
	<#if entity.hasGenerics()>
	<#list entity.getGenerics() as generic>
		<@constantDeclaration generic/>
	</#list>
	</#if>
</#macro>

<#macro constantDeclaration generic>
CONSTANT ${generic.getName()} : ${generic.getType()}${genericRange(generic)}${showInitialValueGeneric(generic)};
</#macro>

<#macro pasteAsInstanceForTestbench entity>
<#assign libraryVar = r"${"+ "work" + "}">
${common.instanceName("DUT")} : ENTITY ${libraryVar}.${entity.getName()}<#t>
<#if !entity.hasGenerics()&&!entity.hasPorts() >;</#if>
<#if entity.hasGenerics() >
	GENERIC MAP ( <#lt>
	<#list entity.getGenerics() as variable>
	<@variableInstance variable/><#if variable_has_next >,</#if>
	</#list>
	<#if entity.hasPorts()>
	)<#lt>
	<#else>
	);<#lt>
	</#if>  
</#if>
<#if entity.hasPorts()> 
	PORT MAP ( <#lt>
	<#list entity.getPorts() as port>
	<@portInstance port /><#if port_has_next >,</#if>
	</#list>
	); <#lt>
</#if>
${common.cursorPosition} <#rt>
</#macro>

<#assign hasClock = false >
<#assign clockName = "">

<#-- Sets the first port that has *clk* or *clock* to be the clock name. -->
<#macro determineClock entity>
<#if entity.hasPorts()>
	<#list entity.getPorts() as port>
	<#if (port.getName()?matches("\\w*clk\\w*", "i")||port?matches("\\w*clock\\w*","i")) > 
		<#assign hasClock = true>
		<#assign clockName = port.getName()>
		<#return>
	</#if>
	</#list>
</#if>
</#macro>

<#macro clockGenerationStatement >
<#assign clockVar = r"${" + clockName + "}">
PROCESS
BEGIN
    ${clockVar} <= '0';
    WAIT FOR 10 ns;
    ${clockVar} <= '1';
    WAIT FOR 10 ns;
END PROCESS;
</#macro>

<#macro pasteAsTestbench entity>
<#assign testbenchName>${common.instanceName(entity.getName(),"", "_tb")}</#assign>
<#assign architectureName>${common.instanceName(entity.getName(), "rtl_")}</#assign>
<#assign configurationName>${common.instanceName(entity.getName(), "rtl_", "_tb_config")}</#assign>
<@determineClock entity/>

LIBRARY IEEE;
USE IEEE.STD_LOGIC_1164.ALL;

ENTITY ${testbenchName} IS
END ENTITY ${testbenchName};   

ARCHITECTURE  ${architectureName} OF ${testbenchName} IS

<#if entity.hasGenerics()>
<@listGenerics entity/>

</#if>
<#if entity.hasPorts()>
<@pasteAsSignals entity/>

</#if>
<#if !hasClock>
<#assign clockName = "clk">
<#assign clockVar = r"${" + clockName + "}">
SIGNAL ${clockVar} : STD_LOGIC;         
</#if>
BEGIN

<@pasteAsInstanceForTestbench entity/>

<@clockGenerationStatement/>

END ARCHITECTURE ${architectureName};

CONFIGURATION ${configurationName} OF ${testbenchName} IS
  FOR ${architectureName}
  END FOR;
END ${configurationName};

</#macro>

<#-- // Paste as Component //-->

<#macro portDeclaration port >
<#assign portName = r"${" + port.getName() + "}" >
<#assign portType = port.getType()!"std_logic" >
<#assign portDirection = port.getDirection()!"" >
${portName} : ${portDirection} ${portType}${portRange(port)}${showInitialValueGeneric(port)}<#t>
</#macro>

<#macro genericDeclaration generic>
${generic.getName()} : ${generic.getType()}${genericRange(generic)}${showInitialValueGeneric(generic)}<#t>
</#macro>	

<#macro pasteAsComponent entity >
COMPONENT ${common.instanceName(entity.getName())}<#t>
<#if !entity.hasGenerics()&&!entity.hasPorts() >;</#if>
<#if entity.hasGenerics() >
	GENERIC ( <#lt>
	<#list entity.getGenerics() as generic>
	<@genericDeclaration generic/><#if generic_has_next >;</#if>
	</#list>
	);<#lt>
</#if>
<#if entity.hasPorts()> 
	PORT ( <#lt>
	<#list entity.getPorts() as port>
	<@portDeclaration port /><#if port_has_next >;</#if>
	</#list>
	); <#lt>
</#if>
END COMPONENT ${common.instanceName(entity.getName())};
${common.cursorPosition} <#rt>
</#macro>


<#macro pasteAsWaveDromDiagram entity>
<#assign max_port_name_chr = 0>
<#assign result = "">

<#-- Wavedrom start -->


<#--Determine the max length for ports -->
<#if entity.hasPorts()>
	<#list entity.getPorts() as port>
		<#assign port_name_chr = (port.getName())?length>
		<#if max_port_name_chr < port_name_chr>
			<#assign max_port_name_chr = port_name_chr>
		</#if>
	</#list>
</#if>

<#--print ports -->
<#if entity.hasPorts()>
	<#assign result = "--@WAVEDROM_START\n--{ signal: [\n">

	<#list entity.getPorts() as port>
		<#assign port_is_clock = false>
		
		<#assign port_name = port.getName()>
		<#assign pad = max_port_name_chr + 9>

		<#if port_name?contains("clock")>
			<#assign port_is_clock = true>
		</#if>

		<#if port_name?contains("clk")>
			<#assign port_is_clock = true>
		</#if>

		<#assign display_name = "name: \"" + port_name + "\",">
		<#assign display_wave = "wave: \"L.........\"">
		<#if port_is_clock == true>
			<#assign display_wave = "wave: \"P.........\"">
		</#if>

		<#assign result = result + "--  { " + display_name?right_pad(pad) + " " + display_wave + " },\n">
	</#list>

	<#assign result = result + "--]}\n--@WAVEDROM_END\n">
</#if>

${result}
</#macro>


