
<#function showPackedDimension port>
	<#if port.getData().hasPackedDimension()>
		<#return port.getData().getPackedDimension() + " ">
	</#if>
	<#return "">	 
</#function>

<#function showUnpackedDimension port>
	<#if port.getData().hasUnpackedDimension()>
		<#return " " + port.getData().getUnpackedDimension()>
	</#if>
	<#return "">	 
</#function>


<#--//      Paste as module instance      //-->

<#macro portNameOrder port>
	<#assign portName = r"${" + port.getName() + "}">
	.${port.getName()}(${portName})<#t>
</#macro>

<#macro parameterNameOrder parameter>
	<#assign parameterName = r"${" + parameter.getName() + "}">
	.${parameter.getName()}(${parameterName})<#t>
</#macro>

<#macro pasteAsInstance module instance_name="">
${module.getName()} <#t>
<#if module.hasParameters()>
#(
	<#list module.getParameters() as parameter>
	<@parameterNameOrder parameter/><#if parameter_has_next>,</#if>
	</#list>
) <#t>
</#if>
<#assign instanceName = "">
<#if instance_name?has_content> 
	<#assign instanceName = instance_name>
<#else>
	<#assign instanceName = common.instanceName(module.getName(),"u_")>
</#if>${instanceName} <#t>
<#if module.hasPorts()>
(
	<#list module.getPorts() as port>
		<@portNameOrder port /><#if port_has_next>,</#if>
	</#list>
);<#t>
<#else>
();<#t>
</#if>
${common.cursorPosition}<#t>
</#macro>

<#--//      Paste as signals declarations      //-->

<#function signalDeclaration port>
	<#assign signalName = r"${" + port.getName() + "}" >
	<#assign showNetType = true>
	<#assign showType = true>
	<#assign netType = port.getData().getNetType()>
	<#if !netType?has_content>
		<#assign netType = "wire">
	</#if>
	<#assign type = port.getData().getType()>
	<#if !type?has_content>
		<#assign type = "logic">
	</#if>
	
	<#-- error conditions -->
	<#if (type == "logic")>
		<#assign showType = false>
	</#if>
	<#if (type == "reg"      || 
		  type == "bit"      ||
		  type == "byte"     ||
		  type == "shortint" ||
		  type == "int"      ||
		  type == "longint"  ||
		  type == "integer"  ||
		  type == "time"     ||
		  type == "shortreal"||
		  type == "real"     ||
		  type == "realtime" ||
		  type == "string"   ||
		  type == "enum"     ||
		  type == "event"    ||
		  type == "struct"   ||
		  type == "union"    ||
		  type == "chandle") >
		<#if (netType == "wire"    ||
			  netType == "wand"    ||
			  netType == "wor"     ||
			  netType == "supply0" ||
			  netType == "supply1" ||
			  netType == "tri"     ||
			  netType == "triand"  ||
			  netType == "trior"   ||
			  netType == "trireg"  ||
			  netType == "tri0"    ||
			  netType == "tri1") >
			<#assign showNetType = false>
		</#if>
	</#if>	
	<#assign result = "">
	<#if showNetType>
		<#assign result = result + netType + " " >
 	</#if>
 	<#if showType>
 		<#assign result = result + type + " " >
 	</#if>
 	<#if port.getData().hasSign()>
 		<#assign result = result + port.getData().getSign() + " ">
 	</#if>	
 	<#assign result = result + showPackedDimension(port)>
	<#return result + signalName + showUnpackedDimension(port) + ";">
</#function>

<#function logicSignalDeclaration port>
	<#assign signalName = r"${" + port.getName() + "}" >
	<#assign type = port.getData().getType()>
	<#if !type?has_content>
		<#assign type = "logic">
	</#if>
	
	<#-- if signal has a type, keep it -->
	<#if (type != "logic")>
		${signalDeclaration(port)}
	</#if>
	<#assign result = "">
 	<#assign result = result + type + " " >
 	<#if port.getData().hasSign()>
 		<#assign result = result + port.getData().getSign() + " ">
 	</#if>	
 	<#assign result = result + showPackedDimension(port)>
	<#return result + signalName + showUnpackedDimension(port) + ";">
</#function>

<#macro pasteAsSignals module>
<#if module.hasPorts()>
<#list module.getPorts() as port>
<#if port.isInterfacePort()>
	<#if !port.isGenericInterfacePort()>
		<@pasteAsInstance port.getInterface() port.getName()/>
	</#if>
<#else>
${signalDeclaration(port)} 
</#if>
</#list>
</#if>
</#macro> 

<#macro pasteAsLogicSignals module>
<#if module.hasPorts()>
<#list module.getPorts() as port>
<#if port.isInterfacePort()>
	<#if !port.isGenericInterfacePort()>
		<@pasteAsInstance port.getInterface() port.getName()/>
	</#if>
<#else>
${logicSignalDeclaration(port)} 
</#if>
</#list>
</#if>
</#macro> 

<#--//      Paste as testbench      //-->

<#assign hasClock = false >
<#assign clockName = "">
<#-- Sets the first port that has *clk* or *clock* to be the clock name. -->
<#macro determineClock module>
<#if module.hasPorts()>
	<#list module.getPorts() as port>
	<#if (port.getName()?matches("\\w*clk\\w*", "i")||port?matches("\\w*clock\\w*","i")) > 
		<#assign hasClock = true>
		<#assign clockName = port.getName()>
		<#return>
	</#if>
	</#list>
</#if>
</#macro>

<#macro parameterDeclaration parameter>
	localparam ${parameter.getName()}<#if parameter.hasInitialValue()> = ${parameter.getInitialValue()};<#else>;</#if>  
</#macro>

<#macro listParameters module>
<#if module.hasParameters()>
<#list module.getParameters() as parameter>
	<@parameterDeclaration parameter/><#lt>
</#list>
</#if>
</#macro> 

<#macro initializeInputPorts module>
<#if module.hasPorts()>
<#list module.getPorts() as port>
	<#if port.getDirection() = "input">
	<#if port.getData().hasUnpackedDimension()>
	${common.instanceName(port.getName())} = '{default:${port.getData().getType()}'(0)};
	<#else>
	<#if (port.getData().getType() == "logic"     ||
	      port.getData().getType() == "reg"       ||
	      port.getData().getType() == "bit"       ||
	      port.getData().getType() == "byte"      ||
	      port.getData().getType() == "int"       ||
	      port.getData().getType() == "integer"   ||
	      port.getData().getType() == "real"      ||
	      port.getData().getType() == "realtime"  ||
	      port.getData().getType() == "shortint"  || 
	      port.getData().getType() == "longint"   ||
	      port.getData().getType() == "shortreal" ||
	      port.getData().getType() == "time" )>
	${common.instanceName(port.getName())} = 0;
	<#else>
	${common.instanceName(port.getName())} = ${port.getData().getType()}'(0);
	</#if>
	</#if>
	</#if>
</#list>
</#if>
</#macro>

<#function testbenchWireDeclaration port>
	<#assign result = "">
	<#if port.getDirection() != "input" && port.getDirection() != "inout">
		<#assign result = result + port.getData().getNetType() + " ">
	</#if>	
	<#assign result = result + port.getData().getType() + " ">   
	<#if port.getData().hasSign()>
		<#assign result = result + port.getData().getSign() + " ">
	</#if>
	<#return result + showPackedDimension(port) + common.instanceName(port.getName()) + showUnpackedDimension(port)> 
</#function>

<#-- Testbench signals are reg for input/inout direction and wire for any other direction -->
<#macro testbenchSignals module>
<#if module.hasPorts()>
<#list module.getPorts() as port>
	<#if port.isInterfacePort()>
		<#if !port.isGenericInterfacePort()>
			<@pasteAsInstance port.getInterface() port.getName()/>
		</#if>
	<#else>
	<#if ((port.getDirection() == "input" || port.getDirection() == "inout") && port.getData().getType() == "logic")>
	reg ${showPackedDimension(port)}${common.instanceName(port.getName())}${showUnpackedDimension(port)};
	<#elseif (port.getDirection() == "output" && (port.getData().getType() == "logic" || port.getData().getType() == "reg"))>
	wire ${showPackedDimension(port)}${common.instanceName(port.getName())}${showUnpackedDimension(port)};
	<#else>
	${testbenchWireDeclaration(port)};
	</#if>
	</#if>
</#list>
</#if>
</#macro>

<#macro pasteAsInstanceForTestbench module>
${module.getName()} <#t>
<#if module.hasParameters()>
#(
	<#list module.getParameters() as parameter>
	<@parameterNameOrder parameter/><#if parameter_has_next>,</#if>
	</#list>
) <#t>
</#if>${common.instanceName("dut")} <#t>
<#if module.hasPorts()>
(
	<#list module.getPorts() as port>
		<@portNameOrder port /><#if port_has_next>,</#if>
	</#list>
);<#lt>
<#else>
();<#lt>
</#if>
${common.cursorPosition}<#rt>
</#macro>	
	
<#macro clockGenerationStatement >
<#assign clockVar = r"${" + clockName + "}">
always
	#5 ${clockVar} = ! ${clockVar};
</#macro>

<#macro pasteAsTestbench module>
<#assign testbenchName>${common.instanceName(module.getName(),"","_tb")}</#assign>
<@determineClock module/>

module ${testbenchName};

<#if module.hasParameters()>
<@listParameters module/>

</#if>
<#if module.hasPorts()>
<@testbenchSignals module/>

</#if>
<#if !hasClock>
<#assign clockName = "clk">
<#assign clockVar = r"${" + clockName + "}">
reg ${clockVar};         
</#if>
<@pasteAsInstanceForTestbench module/>

initial
begin
<@initializeInputPorts module/>
end

<@clockGenerationStatement/>

endmodule
</#macro>

<#macro pasteAsWaveDromDiagram module>
<#assign max_port_name_chr = 0>
<#assign result = "">

<#-- Wavedrom start -->


<#--Determine the max length for ports -->
<#if module.hasPorts()>
	<#list module.getPorts() as port>
		<#assign port_name_chr = (port.getName())?length>
		<#if max_port_name_chr < port_name_chr>
			<#assign max_port_name_chr = port_name_chr>
		</#if>
	</#list>
</#if>

<#--print ports -->
<#if module.hasPorts()>
	<#assign result = "/*\n@WAVEDROM_START\n{ signal: [\n">

	<#list module.getPorts() as port>
		<#assign port_is_clock = false>
		
		<#assign port_name = port.getName()>
		<#assign pad = max_port_name_chr + 9>

		<#if port_name?contains("clock")>
			<#assign port_is_clock = true>
		</#if>

		<#if port_name?contains("clk")>
			<#assign port_is_clock = true>
		</#if>

		<#assign display_name = "name: \"" + port_name + "\",">
		<#assign display_wave = "wave: \"L.........\"">
		<#if port_is_clock == true>
			<#assign display_wave = "wave: \"P.........\"">
		</#if>

		<#assign result = result + "  { " + display_name?right_pad(pad) + " " + display_wave + " },\n">
	</#list>

	<#assign result = result + "]}\n@WAVEDROM_END\n*/">
</#if>

${result}
</#macro>



