header {
package ro.amiq.dvt.logviewer.query.parsing;

import java.util.LinkedList;
import ro.amiq.dvt.logviewer.LogViewerConst;
}

class LogViewerContentAssistQueryParser extends Parser;
options {
    k = 2;
    buildAST = false;
    importVocab = LogViewerQueryLexer;
}

{
    private String prevAttribute;
    private String prevTokenText;
    private LogViewerQueryParsingStatus prevStatus;
    private LogViewerQueryParsingStatus expectedTokenStatus;
    private LinkedList<String> sortAttributes = new LinkedList<>();
    private LinkedList<String> hideAttributes = new LinkedList<>();

    public void reportError(RecognitionException e) {
    	try {
    		throw e;
    	} catch (NoViableAltException ex) {
    		Token token = ex.token;
    		if (token != null && token.getType() != EOF)
    			throw new LogViewerInvalidQuerySyntaxException();

    		throw new LogViewerContentAssistAvailableException();
    	} catch (MismatchedTokenException ex) {
    		Token token = ex.token;
    		if (token != null && token.getType() != EOF)
    			throw new LogViewerInvalidQuerySyntaxException();

    		throw new LogViewerContentAssistAvailableException();
    	} catch (Exception ex) {
    		throw new LogViewerInvalidQuerySyntaxException();
    	}
    }
	
	protected String getPrevAttribute() {
		return prevAttribute;
	}
    
    protected LogViewerQueryParsingStatus getExpectedTokenStatus() {
		return expectedTokenStatus;
	}

    protected LogViewerQueryParsingStatus getPrevStatus() {
		return prevStatus;
	}

    protected String getPrevTokenText() {
		return prevTokenText;
	}

    protected LinkedList<String> getSortAttributes() {
		return sortAttributes;
	}

    protected LinkedList<String> getHideAttributes() {
		return hideAttributes;
	}
}

expression: logicalOr EOF ;

logicalOr: logicalAnd ( or logicalAnd)* ;

or
	{
		expectedTokenStatus = LogViewerQueryParsingStatus.CLAUSE_CHAINING;
	}
	: OR
	{
		expectedTokenStatus = null;
		prevStatus = LogViewerQueryParsingStatus.CLAUSE_CHAINING;
		prevTokenText = "||";
	}
	;

logicalAnd: clause (and clause)* ;

and
	{
		expectedTokenStatus = LogViewerQueryParsingStatus.CLAUSE_CHAINING;
	}
	: AND
	{
		expectedTokenStatus = null;
		prevStatus = LogViewerQueryParsingStatus.CLAUSE_CHAINING;
		prevTokenText = "&&";
	}
	;

clause
    : leftParenthesis logicalOr rightParenthesis
    | comparison
   	| command
    ;

leftParenthesis
	{
		expectedTokenStatus = LogViewerQueryParsingStatus.LEFT_PARENTHESIS;
	}
	: LPAREN
	{
		expectedTokenStatus = null;
		prevStatus = LogViewerQueryParsingStatus.LEFT_PARENTHESIS;
		prevTokenText = "(";
	}
	;

rightParenthesis
	{
		expectedTokenStatus = LogViewerQueryParsingStatus.RIGHT_PARENTHESIS;
	}
	: RPAREN
	{
		expectedTokenStatus = null;
		prevStatus = LogViewerQueryParsingStatus.RIGHT_PARENTHESIS;
		prevTokenText = ")";
	}
	;

comparison
	{
		String attr = null;
	}
	: attr=attribute operator value ;

attribute returns [String text]
	{
		expectedTokenStatus = LogViewerQueryParsingStatus.ATTRIBUTE;
		text = null;
	}
    : w:WORD
    	{
    		text = w.getText();
    		expectedTokenStatus = null;
			prevStatus = LogViewerQueryParsingStatus.ATTRIBUTE;
			prevTokenText = text;
			prevAttribute = text;
    	};

operator
	{
		expectedTokenStatus = LogViewerQueryParsingStatus.OPERATOR;
	}
    : EQ
    	{
    		expectedTokenStatus = null;
			prevStatus = LogViewerQueryParsingStatus.OPERATOR;
			prevTokenText = "=";
    	}
    | NE
    	{
    		expectedTokenStatus = null;
			prevStatus = LogViewerQueryParsingStatus.OPERATOR;
			prevTokenText = "!=";
    	}
    | LT
    	{
    		expectedTokenStatus = null;
			prevStatus = LogViewerQueryParsingStatus.OPERATOR;
			prevTokenText = "<";
    	}
    | LE
    	{
    		expectedTokenStatus = null;
			prevStatus = LogViewerQueryParsingStatus.OPERATOR;
			prevTokenText = "<=";
    	}
    | GT
    	{
    		expectedTokenStatus = null;
			prevStatus = LogViewerQueryParsingStatus.OPERATOR;
			prevTokenText = ">";
    	}
    | GE
    	{
    		expectedTokenStatus = null;
			prevStatus = LogViewerQueryParsingStatus.OPERATOR;
			prevTokenText = ">=";
    	}
    ;
    
value
	{
		expectedTokenStatus = LogViewerQueryParsingStatus.VALUE;
	}
    : s:STRING
    	{
    		expectedTokenStatus = null;
			prevStatus = LogViewerQueryParsingStatus.VALUE;
			prevTokenText = s.getText();
    	}
    | w:WORD
    	{
    		expectedTokenStatus = null;
			prevStatus = LogViewerQueryParsingStatus.VALUE;
			prevTokenText = w.getText();
    	}
    ;

command: sortByCommand | hideCommand ;

sortByCommand
	{
		expectedTokenStatus = LogViewerQueryParsingStatus.SORTBY_COMMAND;
	    String attributeName = null;
	    Character firstChar = null;
	}
    : sortByToken attributeName=attribute
    	{
    		firstChar = attributeName.charAt(0);
    		if (firstChar == LogViewerConst.ASCENDING_SORT_ORDER_CHAR || firstChar == LogViewerConst.DESCENDING_SORT_ORDER_CHAR)
    			attributeName = attributeName.substring(1);

    		sortAttributes.add(attributeName);
    	}
      ( sortByAttrSeparator attributeName=attribute
        {
      		firstChar = attributeName.charAt(0);
    		if (firstChar == LogViewerConst.ASCENDING_SORT_ORDER_CHAR || firstChar == LogViewerConst.DESCENDING_SORT_ORDER_CHAR)
    		    attributeName = attributeName.substring(1);

    		sortAttributes.add(attributeName);
      	}
      )*
	    {
	    	expectedTokenStatus = null;
	    	prevStatus = LogViewerQueryParsingStatus.SORTBY_COMMAND;
	    	prevTokenText = sortAttributes.getLast();
	    }
    ;

sortByToken
	{
		expectedTokenStatus = LogViewerQueryParsingStatus.SORTBY_TOKEN;
	}
	: SORTBY
		{
			expectedTokenStatus = null;
	    	prevStatus = LogViewerQueryParsingStatus.SORTBY_TOKEN;
	    	prevTokenText = LogViewerConst.SORTBY_COMMAND;
		}
	;

sortByAttrSeparator
	{
		expectedTokenStatus = LogViewerQueryParsingStatus.SORTBY_ATTRIBUTE_SEPARATOR;
	}
	: COMMA
		{
			expectedTokenStatus = null;
	    	prevStatus = LogViewerQueryParsingStatus.SORTBY_ATTRIBUTE_SEPARATOR;
	    	prevTokenText = LogViewerConst.COMMAND_ATTRIBUTE_SEPARATOR;
		}
	;

hideCommand
	{
		expectedTokenStatus = LogViewerQueryParsingStatus.HIDE_COMMAND;
	    String attributeName = null;
	}
    : hideToken attributeName=attribute { hideAttributes.add(attributeName); }
      ( hideAttrSeparator attributeName=attribute { hideAttributes.add(attributeName); } )*
	    {
	    	expectedTokenStatus = null;
	    	prevStatus = LogViewerQueryParsingStatus.HIDE_COMMAND;
	    	prevTokenText = hideAttributes.getLast();
	    }
    ;

hideToken
	{
		expectedTokenStatus = LogViewerQueryParsingStatus.HIDE_TOKEN;
	}
	: HIDE
		{
			expectedTokenStatus = null;
	    	prevStatus = LogViewerQueryParsingStatus.HIDE_TOKEN;
	    	prevTokenText = LogViewerConst.HIDE_COMMAND;
		}
	;

hideAttrSeparator
	{
		expectedTokenStatus = LogViewerQueryParsingStatus.HIDE_ATTRIBUTE_SEPARATOR;
	}
	: COMMA
		{
			expectedTokenStatus = null;
	    	prevStatus = LogViewerQueryParsingStatus.HIDE_ATTRIBUTE_SEPARATOR;
	    	prevTokenText = LogViewerConst.COMMAND_ATTRIBUTE_SEPARATOR;
		}
	;
