header {
package ro.amiq.dvt.logviewer.query.parsing;

import ro.amiq.dvt.logviewer.LogViewerConst;
}

class LogViewerQueryLexer extends Lexer;
options {
    k = 2;
}
tokens {
	HIDE;
	SORTBY;
}
{
    public void reportError(RecognitionException e) {
		throw new LogViewerInvalidQuerySyntaxException();
    }
}

LPAREN   : '(' ;
RPAREN   : ')' ;
AND      : "&&" ;
OR       : "||" ;
EQ       : "=" ;
NE       : "!=" ;
LE       : "<=" ;
GE       : ">=" ;
LT       : "<" ;
GT       : ">" ;

COMMA 	 : "," ;

STRING   : '"' (~'"')* '"' ;
WORD 	 : (~('"' | '\t' | ' ' | '\n' | '\r' | '(' | ')' | '=' | '<' | '>' | '&' | '|' | ','))+
	{
		String wordText = getText();
		if (wordText.equals(LogViewerConst.HIDE_COMMAND))
			_ttype = HIDE;
		
		if (wordText.equals(LogViewerConst.SORTBY_COMMAND))
			_ttype = SORTBY;
	} ;

WS       : ( ' ' | '\t' | '\n' | '\r' )+
	{
		_ttype = Token.SKIP;
	} ;
